/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.armor.thorns;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public class EnchantmentBurningThorns
extends EnchantmentBase {
    public EnchantmentBurningThorns(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.burningThorns;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.burningThorns;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.burningThorns, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.burningThorns, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.burningThorns, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.burningThorns, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.burningThorns;
    }

    public void func_151367_b(EntityLivingBase user, Entity attacker, int level) {
        if (!this.isEnabled()) {
            return;
        }
        Random random = user.func_70681_au();
        ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)this, (EntityLivingBase)user);
        if (itemstack.func_190926_b()) {
            return;
        }
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)itemstack);
        if (lvl <= 0) {
            return;
        }
        if (EnchantmentBurningThorns.shouldHit(level, random)) {
            attacker.func_70097_a(DamageSource.func_92087_a((Entity)user), (float)EnchantmentBurningThorns.getDamage(level, random));
            attacker.func_70015_d(level + 2);
            EnchantmentBurningThorns.damageArmor(itemstack, 4, user);
        } else {
            EnchantmentBurningThorns.damageArmor(itemstack, 2, user);
        }
    }

    private static boolean shouldHit(int level, Random rnd) {
        return level > 0 && rnd.nextFloat() < 0.15f * (float)level;
    }

    private static int getDamage(int level, Random rnd) {
        return 2 + rnd.nextInt(4);
    }

    private static void damageArmor(ItemStack stack, int amount, EntityLivingBase entity) {
        int slot = -1;
        int x = 0;
        for (ItemStack i : entity.func_184193_aE()) {
            if (i == stack) {
                slot = x;
                break;
            }
            ++x;
        }
        if (entity.func_70027_ad()) {
            return;
        }
        if (slot == -1 || !(stack.func_77973_b() instanceof ISpecialArmor)) {
            stack.func_77972_a(amount, entity);
            return;
        }
        ISpecialArmor armor = (ISpecialArmor)stack.func_77973_b();
        armor.damageArmor(entity, stack, DamageSource.func_92087_a((Entity)entity), amount, slot);
    }
}

