/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.armor.protection;

import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.EnchantUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentSupremeProtection
extends EnchantmentBase {
    public EnchantmentSupremeProtection(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
        this.field_77351_y = EnumEnchantmentType.ARMOR;
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.supremeProtection;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    public int func_77319_d() {
        return 10;
    }

    @Override
    public int func_77325_b() {
        return 10;
    }

    @Override
    public int func_77321_a(int level) {
        return 1000;
    }

    @Override
    public int func_77317_b(int level) {
        return 1000;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.field_77351_y.func_77557_a(stack.func_77973_b()) && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public boolean func_185261_e() {
        return true;
    }

    public int func_77318_a(int level, DamageSource source) {
        return source.func_76357_e() ? 0 : 8;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurtEvent_extraProtection(LivingHurtEvent event) {
        if (!ModConfig.miscellaneous.extraProtectionEffects) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        int totalLevel = EnchantUtil.getTotalArmorEnchantmentLevel(this, event.getEntityLiving());
        if (totalLevel > 0) {
            float modifier = 1.0f - 0.05f * (float)totalLevel / (float)this.func_77325_b();
            event.setAmount(event.getAmount() * modifier);
        }
    }
}

