/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.armor.protection;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.EnchantUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentAdvancedProtection
extends EnchantmentBase {
    public EnchantmentAdvancedProtection(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.advancedProtection;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.advancedProtection;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedProtection, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedProtection, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedProtection, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedProtection, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.advancedProtection;
    }

    public int func_77318_a(int level, DamageSource source) {
        return source.func_76357_e() ? 0 : level * 2;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurtEvent_extraProtection(LivingHurtEvent event) {
        if (!ModConfig.miscellaneous.extraProtectionEffects) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        int modifier = (int)(4.75f * (float)EnchantUtil.getTotalArmorEnchantmentLevel(this, event.getEntityLiving()));
        float damage = EnchantUtil.getDamageAfterMagicAbsorb(event.getAmount(), modifier);
        event.setAmount(damage);
    }
}

