/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.armor.protection;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.EnchantUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentAdvancedBlastProtection
extends EnchantmentBase {
    public EnchantmentAdvancedBlastProtection(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    public static int getValue(EntityLivingBase entity) {
        if (!EnchantmentRegistry.advancedBlastProtection.isEnabled()) {
            return 0;
        }
        if (entity == null) {
            return 0;
        }
        int i = EnchantmentHelper.func_185284_a((Enchantment)EnchantmentRegistry.advancedBlastProtection, (EntityLivingBase)entity);
        return 2 * i;
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.advancedBlastProtection;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.advancedBlastProtection;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedBlastProtection, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedBlastProtection, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedBlastProtection, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedBlastProtection, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.advancedBlastProtection;
    }

    public int func_77318_a(int level, DamageSource source) {
        return source.func_76357_e() ? 0 : (source.func_94541_c() ? level * 3 : 0);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingHurtEvent_extraProtection(LivingHurtEvent event) {
        if (!ModConfig.miscellaneous.extraProtectionEffects) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!event.getSource().func_94541_c()) {
            return;
        }
        int modifier = (int)(7.5f * (float)EnchantUtil.getTotalArmorEnchantmentLevel(this, event.getEntityLiving()));
        float damage = EnchantUtil.getDamageAfterMagicAbsorb(event.getAmount(), modifier);
        event.setAmount(damage);
    }
}

