/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.armor;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentSwiftSwimming
extends EnchantmentBase {
    private static final UUID SWIFTSWIMMING_UUID = UUID.fromString("a612fe81-132f-4c58-a335-13c4ae5cba21");

    public EnchantmentSwiftSwimming(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.swiftSwimming;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.swiftSwimming;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.swiftSwimming, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.swiftSwimming, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.swiftSwimming, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.swiftSwimming, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.swiftSwimming;
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving().field_70173_aa % 20 != 0) {
            return;
        }
        EntityLivingBase user = event.getEntityLiving();
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)user);
        IAttributeInstance swimSpeed = user.func_110148_a(EntityLivingBase.SWIM_SPEED);
        if (level > 0) {
            EnchantmentSwiftSwimming.addSwimSpeedModifier(level, swimSpeed);
        } else {
            swimSpeed.func_188479_b(SWIFTSWIMMING_UUID);
        }
    }

    private static void addSwimSpeedModifier(int level, IAttributeInstance instance) {
        double amount = 1.3 + 0.4 * (double)level;
        AttributeModifier modifier = new AttributeModifier(SWIFTSWIMMING_UUID, "SwiftSwimmingBoost", amount, 1);
        AttributeModifier previous = instance.func_111127_a(SWIFTSWIMMING_UUID);
        if (previous == null) {
            instance.func_111121_a(modifier);
        } else if (previous.func_111164_d() != amount) {
            instance.func_188479_b(SWIFTSWIMMING_UUID);
            instance.func_111121_a(modifier);
        }
    }
}

