/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.armor;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.BlockRegistry;
import com.shultrea.rin.registry.EnchantmentRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentMagmaWalker
extends EnchantmentBase {
    public EnchantmentMagmaWalker(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    public static void walkOnMagma(EntityLivingBase living, World worldIn, BlockPos pos, int level) {
        if (!EnchantmentRegistry.magmaWalker.isEnabled()) {
            return;
        }
        if (!living.field_70122_E) {
            return;
        }
        float range = Math.min(16, 2 + level);
        BlockPos.MutableBlockPos posAbove = new BlockPos.MutableBlockPos(0, 0, 0);
        for (BlockPos.MutableBlockPos mutable : BlockPos.func_177975_b((BlockPos)pos.func_177963_a((double)(-range), -1.0, (double)(-range)), (BlockPos)pos.func_177963_a((double)range, -1.0, (double)range))) {
            IBlockState state;
            if (!(mutable.func_177957_d(living.field_70165_t, living.field_70163_u, living.field_70161_v) <= (double)(range * range))) continue;
            posAbove.func_181079_c(mutable.func_177958_n(), mutable.func_177956_o() + 1, mutable.func_177952_p());
            IBlockState stateAbove = worldIn.func_180495_p((BlockPos)posAbove);
            if (stateAbove.func_185904_a() != Material.field_151579_a || (state = worldIn.func_180495_p((BlockPos)mutable)).func_185904_a() != Material.field_151587_i || state.func_177230_c() != Blocks.field_150353_l && state.func_177230_c() != Blocks.field_150356_k || (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0 || !worldIn.func_190527_a((Block)BlockRegistry.tempMagma, (BlockPos)mutable, false, EnumFacing.DOWN, null)) continue;
            worldIn.func_175656_a((BlockPos)mutable, BlockRegistry.tempMagma.func_176223_P());
            worldIn.func_175684_a(mutable.func_185334_h(), (Block)BlockRegistry.tempMagma, MathHelper.func_76136_a((Random)living.func_70681_au(), (int)60, (int)120));
        }
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.magmaWalker;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.magmaWalker;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.magmaWalker, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.magmaWalker, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.magmaWalker, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.magmaWalker, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.magmaWalker;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        if (event.getSource() != DamageSource.field_76371_c && event.getSource() != DamageSource.field_190095_e) {
            return;
        }
        if (event.getSource() == DamageSource.field_76371_c && victim.func_180799_ab()) {
            return;
        }
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)victim);
        if (level > 0) {
            event.setCanceled(true);
        }
    }
}

