/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.armor;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EnchantmentLightWeight
extends EnchantmentBase {
    public EnchantmentLightWeight(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.lightWeight;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.lightWeight;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.lightWeight, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.lightWeight, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.lightWeight, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.lightWeight, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.lightWeight;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        if (player == null) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70122_E) {
            return;
        }
        int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)player);
        if (enchantmentLevel > 0 && !player.field_71075_bZ.field_75100_b) {
            float cloud = MathHelper.func_76131_a((float)((float)enchantmentLevel / 3.0f), (float)0.33f, (float)1.0f);
            if (player.field_70143_R >= 3.0f) {
                for (int i = 0; i < 3; ++i) {
                    player.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, player.field_70165_t, player.field_70163_u - 2.0, player.field_70161_v, (double)((player.func_70681_au().nextFloat() - 0.5f) / 2.0f * cloud), -0.5 * (double)cloud, (double)((player.func_70681_au().nextFloat() - 0.5f) / 2.0f * cloud), new int[0]);
                }
            } else if (player.func_70051_ag()) {
                player.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, player.field_70165_t, player.field_70163_u - 1.5, player.field_70161_v, (double)((player.func_70681_au().nextFloat() - 0.5f) / 2.0f * cloud), 0.1 * (double)cloud, (double)((player.func_70681_au().nextFloat() - 0.5f) / 2.0f * cloud), new int[0]);
            }
        }
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)event.getEntityLiving());
        if (enchantmentLevel > 0) {
            event.getEntityLiving().field_70181_x *= 1.05 + (double)enchantmentLevel * 0.15;
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)event.getEntityLiving());
        if (enchantmentLevel > 0) {
            event.setDistance(MathHelper.func_76131_a((float)(event.getDistance() - 4.0f - (float)(enchantmentLevel * 2)), (float)0.0f, (float)20.0f));
        }
    }
}

