/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments.armor;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.registry.EnchantmentRegistry;
import com.shultrea.rin.util.EnchantUtil;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentEvasion
extends EnchantmentBase {
    public EnchantmentEvasion(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.evasion;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.evasion;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.evasion, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.evasion, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.evasion, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.evasion, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.evasion;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingAttackEvent(LivingAttackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getSource().func_76352_a()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null) {
            return;
        }
        if (victim.field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getSource().func_76364_f() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76364_f();
        int level = EnchantmentHelper.func_185284_a((Enchantment)this, (EntityLivingBase)victim);
        if (level > 0) {
            if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.trueStrike, (ItemStack)attacker.func_184614_ca()) > 0) {
                return;
            }
            if (victim.func_70681_au().nextFloat() < 0.05f + (float)level * 0.15f) {
                if (!victim.field_70170_p.field_72995_K && ModConfig.miscellaneous.evasionDodgeEffect) {
                    double randX = 0.65 + victim.func_70681_au().nextDouble() * 0.25;
                    randX = victim.func_70681_au().nextBoolean() ? randX * -1.0 : randX;
                    double randZ = 0.65 + victim.func_70681_au().nextDouble() * 0.25;
                    randZ = victim.func_70681_au().nextBoolean() ? randZ * -1.0 : randZ;
                    EnchantUtil.knockBackIgnoreKBRes((Entity)victim, 0.7f, (attacker.field_70165_t - victim.field_70165_t) * randX, (attacker.field_70161_v - victim.field_70161_v) * randZ);
                }
                victim.func_130014_f_().func_184148_a(null, victim.field_70165_t, victim.field_70163_u, victim.field_70161_v, SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 0.3f, victim.func_70681_au().nextFloat() * 2.25f + 0.75f);
                event.setCanceled(true);
                if ((float)victim.field_70172_ad <= (float)victim.field_70771_an / 2.0f) {
                    victim.field_70172_ad = victim.field_70771_an + 5 * (level - 1);
                }
            }
        }
    }
}

