/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentUpgradedPotentials
extends EnchantmentBase {
    public EnchantmentUpgradedPotentials(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.upgradedPotentials;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.upgradedPotentials;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.upgradedPotentials, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.upgradedPotentials, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.upgradedPotentials, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.upgradedPotentials, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.upgradedPotentials;
    }

    @SubscribeEvent
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        Map enchantments;
        if (!this.isEnabled()) {
            return;
        }
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_190926_b() || right.func_190926_b()) {
            return;
        }
        if (right.func_77973_b() == Items.field_151134_bR && (enchantments = EnchantmentHelper.func_82781_a((ItemStack)right)).getOrDefault((Object)this, 0) > 0) {
            enchantments = EnchantmentHelper.func_82781_a((ItemStack)left);
            if (left.func_77985_e() || enchantments.isEmpty() || enchantments.getOrDefault((Object)this, 0) > 0) {
                event.setCanceled(true);
                return;
            }
            int cost = left.func_82838_A();
            cost = Math.max(0, cost / 4 - 20);
            ItemStack output = left.func_77946_l();
            output.func_82841_c(cost);
            output.func_77966_a((Enchantment)this, 1);
            event.setOutput(output);
            event.setCost(10);
        }
    }
}

