/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.enchantments;

import com.shultrea.rin.config.ConfigProvider;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.config.folders.EnchantabilityConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentAdvancedMending
extends EnchantmentBase {
    public EnchantmentAdvancedMending(String name, Enchantment.Rarity rarity, EntityEquipmentSlot ... slots) {
        super(name, rarity, slots);
    }

    @Override
    public boolean isEnabled() {
        return ModConfig.enabled.advancedMending;
    }

    @Override
    public boolean hasSubscriber() {
        return true;
    }

    @Override
    public int func_77325_b() {
        return ModConfig.level.advancedMending;
    }

    @Override
    public int func_77321_a(int level) {
        return EnchantabilityConfig.getMinEnchantability(ModConfig.enchantability.advancedMending, level);
    }

    @Override
    public int func_77317_b(int level) {
        return EnchantabilityConfig.getMaxEnchantability(ModConfig.enchantability.advancedMending, level);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApply.advancedMending, stack) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean func_92089_a(ItemStack stack) {
        return ConfigProvider.canItemApply(this, ModConfig.canApplyAnvil.advancedMending, stack) || super.func_92089_a(stack);
    }

    @Override
    public boolean func_185261_e() {
        return ModConfig.treasure.advancedMending;
    }

    @SubscribeEvent
    public void onPlayerPickupXPEvent(PlayerPickupXpEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        EntityXPOrb orb = event.getOrb();
        if (orb == null) {
            return;
        }
        if (orb.field_70530_e <= 0) {
            return;
        }
        if (ModConfig.miscellaneous.enableDoubleXPBug) {
            player.func_71023_q(orb.field_70530_e);
        }
        ItemStack stack = ItemStack.field_190927_a;
        if (ModConfig.miscellaneous.advancedMendingPrioritizeDamaged) {
            List equipment = this.func_185260_a((EntityLivingBase)player);
            if (!equipment.isEmpty()) {
                ArrayList<ItemStack> damagedEquipment = new ArrayList<ItemStack>();
                for (ItemStack itemstack : equipment) {
                    if (itemstack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)itemstack) <= 0 || !itemstack.func_77951_h()) continue;
                    damagedEquipment.add(itemstack);
                }
                if (!damagedEquipment.isEmpty()) {
                    stack = (ItemStack)damagedEquipment.get(player.func_70681_au().nextInt(damagedEquipment.size()));
                }
            }
        } else {
            stack = EnchantmentHelper.func_92099_a((Enchantment)this, (EntityLivingBase)player);
        }
        if (!stack.func_190926_b() && stack.func_77951_h()) {
            float ratio = stack.func_77973_b().getXpRepairRatio(stack);
            int value = Math.min(EnchantmentAdvancedMending.roundAverage((float)orb.field_70530_e * ratio * 1.5f), stack.func_77952_i());
            orb.field_70530_e -= EnchantmentAdvancedMending.roundAverage((float)value / ratio);
            stack.func_77964_b(stack.func_77952_i() - value);
            if (orb.field_70530_e < 0) {
                orb.field_70530_e = 0;
            }
        }
    }

    private static int roundAverage(float value) {
        double floor = Math.floor(value);
        return (int)floor + (Math.random() < (double)value - floor ? 1 : 0);
    }
}

