/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.config;

import com.shultrea.rin.SoManyEnchantments;
import com.shultrea.rin.config.ModConfig;
import com.shultrea.rin.enchantments.base.EnchantmentBase;
import com.shultrea.rin.util.Types;
import com.shultrea.rin.util.enchantmenttypes.CustomTypeMatcher;
import com.shultrea.rin.util.enchantmenttypes.EnumEnchantmentTypeMatcher;
import com.shultrea.rin.util.enchantmenttypes.ITypeMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class ConfigProvider {
    private static final HashMap<String, ITypeMatcher> typeMatchers = new HashMap();
    private static List<Enchantment> randomLevelEnchantsBlacklist = null;
    private static List<Enchantment> randomEnchantsBlacklist = null;
    private static List<Enchantment> librarianEnchantsBlacklist = null;
    private static List<Enchantment> enchantTableEnchantsBlacklist = null;
    private static List<String> registryEnchantsBlacklist = null;
    private static ItemStack upgradeTokenItemTier = null;
    private static ItemStack upgradeTokenItemLevel = null;
    private static List<UpgradeTierEntry> upgradeTierEntries = null;
    private static List<UpgradeFailEntry> upgradeFailEntries = null;

    public static Set<Enchantment> getIncompatibleEnchantmentsFromConfig(Enchantment thisEnch) {
        HashSet<Enchantment> incompatEnchs = new HashSet<Enchantment>();
        ResourceLocation regName = thisEnch.getRegistryName();
        if (regName == null) {
            return incompatEnchs;
        }
        for (String configLine : ModConfig.incompatible.incompatibleGroups) {
            String[] enchsInList;
            if (!configLine.contains(regName.func_110623_a())) continue;
            for (String lineEntry : enchsInList = configLine.split(",")) {
                Enchantment incompatEnch;
                if ((lineEntry = lineEntry.trim()).isEmpty()) continue;
                if (!lineEntry.contains(":")) {
                    lineEntry = "somanyenchantments:" + lineEntry;
                }
                if ((incompatEnch = Enchantment.func_180305_b((String)lineEntry)) == null) {
                    SoManyEnchantments.LOGGER.warn("SME: could not find incompatible enchantment {}", (Object)lineEntry);
                    continue;
                }
                incompatEnchs.add(incompatEnch);
            }
        }
        incompatEnchs.remove(thisEnch);
        return incompatEnchs;
    }

    public static void resetCanApply() {
        typeMatchers.clear();
        ConfigProvider.initCanApply();
    }

    public static void initCanApply() {
        typeMatchers.put("ALL_TYPES", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.ALL));
        typeMatchers.put("ARMOR", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.ARMOR));
        typeMatchers.put("ARMOR_HEAD", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.ARMOR_HEAD));
        typeMatchers.put("ARMOR_CHEST", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.ARMOR_CHEST));
        typeMatchers.put("ARMOR_LEGS", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.ARMOR_LEGS));
        typeMatchers.put("ARMOR_FEET", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.ARMOR_FEET));
        typeMatchers.put("SWORD", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.WEAPON));
        typeMatchers.put("TOOL", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.DIGGER));
        typeMatchers.put("FISHING_ROD", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.FISHING_ROD));
        typeMatchers.put("BREAKABLE", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.BREAKABLE));
        typeMatchers.put("BOW", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.BOW));
        typeMatchers.put("WEARABLE", new EnumEnchantmentTypeMatcher(EnumEnchantmentType.WEARABLE));
        typeMatchers.put("ALL_ITEMS", new EnumEnchantmentTypeMatcher(Types.ALL));
        typeMatchers.put("AXE", new EnumEnchantmentTypeMatcher(Types.AXE));
        typeMatchers.put("PICKAXE", new EnumEnchantmentTypeMatcher(Types.PICKAXE));
        typeMatchers.put("HOE", new EnumEnchantmentTypeMatcher(Types.HOE));
        typeMatchers.put("SHOVEL", new EnumEnchantmentTypeMatcher(Types.SPADE));
        typeMatchers.put("SHIELD", new EnumEnchantmentTypeMatcher(Types.SHIELD));
        typeMatchers.put("NONE", new EnumEnchantmentTypeMatcher(Types.NONE));
        for (String s : ModConfig.canApply.customTypes) {
            CustomTypeMatcher c = new CustomTypeMatcher(s);
            if (!c.isValid()) continue;
            typeMatchers.put(c.getName(), c);
        }
    }

    public static boolean canItemApply(EnchantmentBase enchantment, String[] enchantConfig, ItemStack stack) {
        Item item = stack.func_77973_b();
        boolean isValid = false;
        boolean invertedMatches = false;
        String itemName = null;
        for (String s : enchantConfig) {
            ITypeMatcher typeMatcher;
            boolean inverted = false;
            if (s.startsWith("!")) {
                inverted = true;
                s = s.substring(1);
            }
            if ((typeMatcher = (ITypeMatcher)typeMatchers.getOrDefault(s, null)) == null) {
                SoManyEnchantments.LOGGER.info("SME: Could not find given item type {}", (Object)s);
                continue;
            }
            if (typeMatcher instanceof CustomTypeMatcher && itemName == null) {
                ResourceLocation loc = item.getRegistryName();
                itemName = loc != null ? loc.toString() : "";
            }
            boolean matches = typeMatcher.matches(enchantment, stack, item, itemName);
            if (!inverted) {
                isValid = isValid || matches;
                continue;
            }
            invertedMatches = invertedMatches || matches;
        }
        return isValid && !invertedMatches;
    }

    public static void resetBlacklists() {
        randomLevelEnchantsBlacklist = null;
        randomEnchantsBlacklist = null;
        librarianEnchantsBlacklist = null;
        enchantTableEnchantsBlacklist = null;
    }

    public static List<Enchantment> getRandomLevelEnchantsBlacklist() {
        if (randomLevelEnchantsBlacklist == null) {
            randomLevelEnchantsBlacklist = ConfigProvider.populateEnchantmentList(ModConfig.miscellaneous.blacklistedRandomLevelEnchants);
        }
        return randomLevelEnchantsBlacklist;
    }

    public static List<Enchantment> getRandomEnchantsBlacklist() {
        if (randomEnchantsBlacklist == null) {
            randomEnchantsBlacklist = ConfigProvider.populateEnchantmentList(ModConfig.miscellaneous.blacklistedRandomEnchants);
        }
        return randomEnchantsBlacklist;
    }

    public static List<Enchantment> getLibrarianEnchantsBlacklist() {
        if (librarianEnchantsBlacklist == null) {
            librarianEnchantsBlacklist = ConfigProvider.populateEnchantmentList(ModConfig.miscellaneous.blacklistedLibrarianEnchants);
        }
        return librarianEnchantsBlacklist;
    }

    public static List<Enchantment> getEnchantTableEnchantsBlacklist() {
        if (enchantTableEnchantsBlacklist == null) {
            enchantTableEnchantsBlacklist = ConfigProvider.populateEnchantmentList(ModConfig.miscellaneous.blacklistedEnchTableEnchants);
        }
        return enchantTableEnchantsBlacklist;
    }

    private static List<Enchantment> populateEnchantmentList(String[] names) {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        for (String name : names) {
            if ((name = name.trim()).isEmpty()) continue;
            Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(name));
            if (enchant == null) {
                SoManyEnchantments.LOGGER.log(Level.WARN, "Invalid enchantment " + name + " in blacklist");
                continue;
            }
            list.add(enchant);
        }
        return list;
    }

    public static List<String> getRegistryEnchantsBlacklist() {
        if (registryEnchantsBlacklist == null) {
            registryEnchantsBlacklist = Arrays.asList(ModConfig.miscellaneous.blacklistedRegistryEnchants);
        }
        return registryEnchantsBlacklist;
    }

    public static void resetDefaultUpgradeTokens() {
        upgradeTokenItemTier = null;
        upgradeTokenItemLevel = null;
    }

    public static ItemStack setupDefaultUpgradeToken(String configEntry, int defaultCount) {
        ItemStack upgradeTokens = null;
        String[] itemSplit = configEntry.split(":");
        try {
            int metadata = itemSplit.length > 2 ? Integer.parseInt(itemSplit[2].trim()) : Short.MAX_VALUE;
            int count = itemSplit.length > 3 ? Integer.parseInt(itemSplit[3].trim()) : defaultCount;
            Item token = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemSplit[0].trim(), itemSplit[1].trim()));
            if (token == null) {
                SoManyEnchantments.LOGGER.log(Level.WARN, "Invalid upgrade token item: " + configEntry);
                token = Items.field_179562_cC;
            }
            upgradeTokens = new ItemStack(token, count, metadata);
        }
        catch (Exception e) {
            SoManyEnchantments.LOGGER.warn("Invalid upgrade token, expected pattern: modid:itemname:optional metadata:optional itemcount, provided was: {}", (Object)configEntry);
        }
        return upgradeTokens;
    }

    public static ItemStack getDefaultUpgradeTokenItems(boolean isLevelUpgrade) {
        if (isLevelUpgrade) {
            if (upgradeTokenItemLevel == null) {
                upgradeTokenItemLevel = ConfigProvider.setupDefaultUpgradeToken(ModConfig.upgrade.upgradeTokenLevel, ModConfig.upgrade.upgradeTokenAmountLevel);
            }
            return upgradeTokenItemLevel;
        }
        if (upgradeTokenItemTier == null) {
            upgradeTokenItemTier = ConfigProvider.setupDefaultUpgradeToken(ModConfig.upgrade.upgradeTokenTier, ModConfig.upgrade.upgradeTokenAmountTier);
        }
        return upgradeTokenItemTier;
    }

    public static Enchantment getFailureEnchantFor(Enchantment ench) {
        if (upgradeFailEntries == null) {
            upgradeFailEntries = new ArrayList<UpgradeFailEntry>();
            for (String entry : ModConfig.upgrade.enchantUpgradeCursing) {
                if ((entry = entry.trim()).isEmpty()) continue;
                ArrayList<Enchantment> enchantmentFailureList = new ArrayList<Enchantment>();
                Enchantment curseEnchantment = null;
                String[] args = entry.split(",");
                for (int i = 0; i < args.length; ++i) {
                    Enchantment enchant;
                    String arg = args[i].trim();
                    if (arg.isEmpty()) continue;
                    if (i == args.length - 1) {
                        if ("none".equals(arg)) {
                            curseEnchantment = null;
                            continue;
                        }
                        enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(arg));
                        if (enchant == null) {
                            SoManyEnchantments.LOGGER.log(Level.WARN, "Invalid curse equivalent curse: " + arg);
                        }
                        curseEnchantment = enchant;
                        continue;
                    }
                    enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(arg));
                    if (enchant == null) {
                        SoManyEnchantments.LOGGER.log(Level.WARN, "Invalid curse equivalent enchantment: " + arg);
                        continue;
                    }
                    enchantmentFailureList.add(enchant);
                }
                upgradeFailEntries.add(new UpgradeFailEntry(enchantmentFailureList, curseEnchantment));
            }
        }
        for (UpgradeFailEntry entry : upgradeFailEntries) {
            if (!entry.enchantmentFailureList.contains(ench)) continue;
            return entry.curse;
        }
        return null;
    }

    public static Enchantment getUpgradedEnchantFor(Enchantment ench) {
        if (upgradeTierEntries == null) {
            upgradeTierEntries = new ArrayList<UpgradeTierEntry>();
            for (String entry : ModConfig.upgrade.enchantUpgradeOrder) {
                String[] args;
                if ((entry = entry.trim()).isEmpty()) continue;
                ArrayList<Enchantment> enchantmentUpgradeList = new ArrayList<Enchantment>();
                for (String arg : args = entry.split(",")) {
                    if ((arg = arg.trim()).isEmpty()) continue;
                    Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(arg));
                    if (enchant == null) {
                        SoManyEnchantments.LOGGER.log(Level.WARN, "Invalid upgrade tier enchantment: " + arg);
                        continue;
                    }
                    enchantmentUpgradeList.add(enchant);
                }
                upgradeTierEntries.add(new UpgradeTierEntry(enchantmentUpgradeList));
            }
        }
        for (UpgradeTierEntry entry : upgradeTierEntries) {
            Enchantment potentialUpgrade = entry.getUpgradedEnchantment(ench);
            if (potentialUpgrade == null) continue;
            return potentialUpgrade;
        }
        return null;
    }

    public static class UpgradeFailEntry {
        private final List<Enchantment> enchantmentFailureList;
        private final Enchantment curse;

        public UpgradeFailEntry(List<Enchantment> enchantmentFailureList, Enchantment curse) {
            this.enchantmentFailureList = enchantmentFailureList;
            this.curse = curse;
        }

        @Nullable
        public Enchantment getCurse() {
            return this.curse;
        }
    }

    public static class UpgradeTierEntry {
        private final List<Enchantment> enchantmentUpgradeList;

        public UpgradeTierEntry(List<Enchantment> enchantmentUpgradeList) {
            this.enchantmentUpgradeList = enchantmentUpgradeList;
        }

        @Nullable
        public Enchantment getUpgradedEnchantment(Enchantment enchantment) {
            int index = this.enchantmentUpgradeList.indexOf(enchantment);
            if (index != -1 && index + 1 < this.enchantmentUpgradeList.size()) {
                return this.enchantmentUpgradeList.get(index + 1);
            }
            return null;
        }
    }
}

