/*
 * Decompiled with CFR 0.152.
 */
package com.shultrea.rin.blocks;

import com.shultrea.rin.registry.EnchantmentRegistry;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTemporaryMagma
extends BlockMagma {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);

    public BlockTemporaryMagma() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("magmaTemp");
        this.setRegistryName("somanyenchantments", "magmaTemp");
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)meta, (int)0, (int)3)));
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if (BlockTemporaryMagma.countNeighborsOfBlock(world, pos, (Block)this) < 4 && BlockTemporaryMagma.countNeighborsOfBlock(world, pos, (Block)Blocks.field_150353_l) > 2 - (Integer)state.func_177229_b((IProperty)AGE)) {
            this.slightlyMelt(world, pos, state, rand, true);
        } else {
            world.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        }
    }

    protected void slightlyMelt(World worldIn, BlockPos pos, IBlockState state, Random rand, boolean meltNeighbors) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 3) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            worldIn.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
        } else {
            this.turnIntoLava(worldIn, pos);
            if (!meltNeighbors) {
                return;
            }
            for (EnumFacing enumfacing : EnumFacing.values()) {
                BlockPos blockpos = pos.func_177972_a(enumfacing);
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                if (iblockstate.func_177230_c() != this) continue;
                this.slightlyMelt(worldIn, blockpos, iblockstate, rand, false);
            }
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        if (blockIn == this && BlockTemporaryMagma.countNeighborsOfBlock(worldIn, pos, (Block)this) < 2) {
            this.turnIntoLava(worldIn, pos);
        }
    }

    protected void turnIntoLava(World world, @Nonnull BlockPos pos) {
        world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
    }

    private static int countNeighborsOfBlock(World world, BlockPos pos, Block comparison) {
        int counter = 0;
        for (EnumFacing facing : EnumFacing.values()) {
            if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != comparison || ++counter < 4) continue;
            return counter;
        }
        return counter;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    @Nonnull
    public ItemStack func_185473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public MapColor func_180659_g(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return MapColor.field_151655_K;
    }

    public void func_176199_a(@Nonnull World world, @Nonnull BlockPos pos, Entity entity) {
        EntityLivingBase entityLivingBase;
        if (!entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)(entityLivingBase = (EntityLivingBase)entity)) && EnchantmentHelper.func_185284_a((Enchantment)EnchantmentRegistry.magmaWalker, (EntityLivingBase)entityLivingBase) <= 0) {
            entity.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
        super.func_176199_a(world, pos, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return 0xF000F0;
    }

    public boolean func_189872_a(@Nonnull IBlockState state, Entity entityIn) {
        return entityIn.func_70045_F();
    }
}

