/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.jsonpaintings.mod.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import git.jbredwards.jsonpaintings.mod.common.util.IJSONPainting;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public final class JSONHandler {
    @Nonnull
    public static final Map<EntityPainting.EnumArt, String> MODID_LOOKUP = new HashMap<EntityPainting.EnumArt, String>();
    @Nonnull
    public static final Map<String, EntityPainting.EnumArt> PAINTING_REMAPS = new HashMap<String, EntityPainting.EnumArt>();
    static int nextPaintingId = 0;
    @Nonnull
    public static final ResourceLocation DEFAULT_BACK_TEXTURE = new ResourceLocation("jsonpaintings", "textures/paintings/back.png");
    @Nonnull
    static final Set<String> newMotives = new HashSet<String>();

    public static void readMods() {
        for (ModContainer container : Loader.instance().getModList()) {
            InputStream file = Loader.class.getResourceAsStream(String.format("/assets/%s/paintings/paintings.json", container.getModId().replaceAll("[<>:\"|?*]", "_")));
            if (file == null) continue;
            try {
                InputStreamReader reader = new InputStreamReader(file);
                Throwable throwable = null;
                try {
                    JSONHandler.read(reader, container, true, false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void readInstance(boolean isReload) throws Exception {
        File file = new File("paintings", "paintings.json");
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                JSONHandler.read(reader, (ModContainer)Loader.instance().getIndexedModList().get("jsonpaintings"), false, isReload);
            }
        }
    }

    static void read(@Nonnull Reader reader, @Nonnull ModContainer container, boolean isModded, boolean isReload) throws Exception {
        JsonArray jsonArray = new JsonParser().parse(reader).getAsJsonArray();
        if (isReload && !newMotives.isEmpty() && !StreamSupport.stream(jsonArray.spliterator(), false).map(JsonElement::getAsJsonObject).map(json -> JsonUtils.func_151200_h((JsonObject)json, (String)"motive")).collect(Collectors.toSet()).containsAll(newMotives)) {
            throw new CommandException("jsonpaintings.command.removedPainting", new Object[0]);
        }
        jsonArray.forEach(jsonIn -> {
            String frontTexturePath;
            JsonObject json = jsonIn.getAsJsonObject();
            String motive = JsonUtils.func_151200_h((JsonObject)json, (String)"motive");
            boolean setModId = true;
            EntityPainting.EnumArt art = null;
            for (EntityPainting.EnumArt artIn : EntityPainting.EnumArt.values()) {
                if (!artIn.field_75702_A.equals(motive)) continue;
                art = artIn;
                art.field_75699_D = 0;
                art.field_75700_E = 0;
                setModId = false;
                if (json.has("width")) {
                    art.field_75703_B = Math.max(JsonUtils.func_151215_f((JsonElement)json.get("width"), (String)"width") << 4, 16);
                }
                if (json.has("height")) {
                    art.field_75704_C = Math.max(JsonUtils.func_151215_f((JsonElement)json.get("height"), (String)"height") << 4, 16);
                }
                IJSONPainting.from(art).setCreative(false);
                IJSONPainting.from(art).setHasBackTexture(false);
                IJSONPainting.from(art).setHasSideTexture(false);
                break;
            }
            if (art == null) {
                art = EnumHelper.addArt((String)("JSON_PAINTINGS_GENERATED_ID" + nextPaintingId++), (String)motive, (int)(json.has("width") ? Math.max(JsonUtils.func_151215_f((JsonElement)json.get("width"), (String)"width") << 4, 16) : 16), (int)(json.has("height") ? Math.max(JsonUtils.func_151215_f((JsonElement)json.get("height"), (String)"height") << 4, 16) : 16), (int)0, (int)0);
                if (art != null) {
                    newMotives.add(motive);
                } else {
                    --nextPaintingId;
                    throw new IllegalArgumentException("A critical error has occurred while creating painting with the motive: " + motive);
                }
            }
            IJSONPainting painting = IJSONPainting.from(art);
            String string = frontTexturePath = isModded ? "paintings/" + motive.toLowerCase() : motive.toLowerCase();
            if (json.has("textures")) {
                String side;
                String back;
                String front;
                JsonObject textures = JsonUtils.func_151210_l((JsonElement)json.get("textures"), (String)"textures");
                String string2 = front = textures.has("front") ? JsonUtils.func_151206_a((JsonElement)textures.get("front"), (String)"front") : container.getModId() + ":" + frontTexturePath;
                if (!textures.has("back")) {
                    back = "jsonpaintings:paintings/back";
                } else {
                    back = JsonUtils.func_151206_a((JsonElement)textures.get("back"), (String)"back");
                    painting.setHasBackTexture(true);
                    painting.setHasSideTexture(true);
                }
                if (!textures.has("side")) {
                    side = back;
                } else {
                    side = JsonUtils.func_151206_a((JsonElement)textures.get("side"), (String)"side");
                    painting.setHasSideTexture(true);
                }
                ImmutableMap textureMap = ImmutableMap.of((Object)"front", (Object)front, (Object)"back", (Object)back, (Object)"side", (Object)side);
                painting.setFrontTexture(JSONHandler.buildLocation(front.charAt(0) == '#' ? (String)textureMap.get((Object)front.substring(1)) : front));
                painting.setBackTexture(JSONHandler.buildLocation(back.charAt(0) == '#' ? (String)textureMap.get((Object)back.substring(1)) : back));
                painting.setSideTexture(JSONHandler.buildLocation(side.charAt(0) == '#' ? (String)textureMap.get((Object)side.substring(1)) : side));
            } else {
                painting.setFrontTexture(JSONHandler.buildLocation(container.getModId() + ":" + frontTexturePath));
                painting.setBackTexture(DEFAULT_BACK_TEXTURE);
                painting.setSideTexture(DEFAULT_BACK_TEXTURE);
            }
            if (motive.length() > EntityPainting.EnumArt.field_180001_A) {
                EntityPainting.EnumArt.field_180001_A = motive.length();
            }
            if (json.has("isCreative")) {
                painting.setCreative(JsonUtils.func_151216_b((JsonElement)json.get("isCreative"), (String)"isCreative"));
                if (painting.isCreative()) {
                    painting.setAlwaysCapture(true);
                }
            } else {
                painting.setAlwaysCapture(false);
            }
            if (json.has("alwaysCapture")) {
                painting.setAlwaysCapture(JsonUtils.func_151216_b((JsonElement)json.get("alwaysCapture"), (String)"alwaysCapture"));
            }
            if (setModId) {
                painting.setModName(container.getName());
                MODID_LOOKUP.put(art, container.getModId());
            }
            if (json.has("rarity")) {
                final JsonElement rarity = json.get("rarity");
                if (rarity.isJsonPrimitive()) {
                    Arrays.stream(EnumRarity.values()).filter(enumRarity -> rarity.getAsString().equalsIgnoreCase(enumRarity.getName())).findFirst().ifPresent(painting::setRarity);
                } else {
                    painting.setRarity(new IRarity(){
                        @Nonnull
                        final String name;
                        @Nonnull
                        final TextFormatting color;
                        {
                            this.name = JsonUtils.func_151200_h((JsonObject)JsonUtils.func_151210_l((JsonElement)rarity, (String)"rarity"), (String)"name");
                            this.color = JSONHandler.getFormatColor(rarity.getAsJsonObject());
                        }

                        @Nonnull
                        public String getName() {
                            return this.name;
                        }

                        @Nonnull
                        public TextFormatting getColor() {
                            return this.color;
                        }
                    });
                }
            }
            if (json.has("mapping")) {
                JsonElement mappingJson = json.get("mapping");
                if (mappingJson.isJsonPrimitive()) {
                    PAINTING_REMAPS.put(mappingJson.getAsString(), art);
                } else {
                    EntityPainting.EnumArt finalArt = art;
                    JsonUtils.func_151207_m((JsonElement)mappingJson, (String)"mapping").forEach(mapping -> PAINTING_REMAPS.put(mapping.getAsString(), finalArt));
                }
            }
            painting.setUseSpecialRenderer(true);
        });
    }

    @Nonnull
    static ResourceLocation buildLocation(@Nonnull String str) {
        ResourceLocation loc = new ResourceLocation(str);
        return new ResourceLocation(loc.func_110624_b(), "textures/" + loc.func_110623_a() + ".png");
    }

    @Nonnull
    static TextFormatting getFormatColor(@Nonnull JsonObject json) {
        String colorKey = JsonUtils.func_151200_h((JsonObject)json, (String)"color");
        return Optional.ofNullable(TextFormatting.func_96300_b((String)colorKey)).orElseGet(() -> Arrays.stream(TextFormatting.values()).filter(format -> format.toString().equals(colorKey)).findFirst().orElseThrow(() -> new NullPointerException("Unknown color: \"" + colorKey + "\", see the following page for a list of all valid colors: https://minecraft.wiki/w/Formatting_codes#Color_codes")));
    }
}

