/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.jsonpaintings.mod.common.item;

import com.mcf.davidee.paintinggui.handler.PlacePaintingEventHandler;
import git.jbredwards.jsonpaintings.mod.JSONPaintings;
import git.jbredwards.jsonpaintings.mod.common.capability.IArtCapability;
import git.jbredwards.jsonpaintings.mod.common.util.IJSONPainting;
import git.jbredwards.jsonpaintings.mod.common.util.JSONHandler;
import io.netty.util.internal.IntegerHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ItemPainting
extends ItemHangingEntity {
    public ItemPainting(@Nonnull Class<? extends EntityHanging> entityClass) {
        super(entityClass);
    }

    @Nullable
    public static EntityPainting.EnumArt getRandomArt(@Nonnull EntityPainting painting, @Nonnull EntityPlayer player, @Nonnull EnumFacing facing) {
        ArrayList<Pair> validArt = new ArrayList<Pair>(EntityPainting.EnumArt.values().length);
        IntegerHolder maxSize = new IntegerHolder();
        for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
            if (!player.func_184812_l_() && IJSONPainting.from(art).isCreative()) continue;
            painting.field_70522_e = art;
            painting.func_174859_a(facing);
            if (!painting.func_70518_d()) continue;
            int size = art.field_75703_B * art.field_75704_C;
            validArt.add(Pair.of((Object)art, (Object)size));
            if (size <= maxSize.value) continue;
            maxSize.value = size;
        }
        validArt.removeIf(pair -> (Integer)pair.getValue() < maxSize.value);
        return validArt.isEmpty() ? null : (EntityPainting.EnumArt)((Pair)validArt.get(painting.field_70170_p.field_73012_v.nextInt(validArt.size()))).getKey();
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos offset;
        EntityPainting.EnumArt art;
        ItemStack stack = player.func_184586_b(hand);
        IArtCapability cap = IArtCapability.get((ICapabilityProvider)stack);
        if (cap != null && ((art = cap.getArt()) != null || !JSONPaintings.IS_PSG_INSTALLED) && facing.func_176740_k().func_176722_c() && player.func_175151_a(offset = pos.func_177972_a(facing), facing, stack)) {
            EntityPainting painting = new EntityPainting(worldIn);
            painting.func_70107_b((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
            if (art != null) {
                painting.field_70522_e = art;
            } else {
                EntityPainting.EnumArt randomArt = ItemPainting.getRandomArt(painting, player, facing);
                if (randomArt != null) {
                    painting.field_70522_e = randomArt;
                } else {
                    return EnumActionResult.PASS;
                }
            }
            painting.func_174859_a(facing);
            if (painting.func_70518_d()) {
                if (!painting.field_70170_p.field_72995_K) {
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    painting.field_70170_p.func_72838_d((Entity)painting);
                    painting.func_184523_o();
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        if (JSONPaintings.IS_PSG_INSTALLED) {
            PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, hand, pos, facing, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
            new PlacePaintingEventHandler().onPaintingPlaced(event);
            if (event.isCanceled()) {
                return event.getCancellationResult();
            }
        }
        return EnumActionResult.PASS;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
                ItemStack stack = new ItemStack((Item)this);
                IArtCapability cap = IArtCapability.get((ICapabilityProvider)stack);
                if (cap == null) continue;
                cap.setArt(art);
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        IArtCapability.getOptional((ICapabilityProvider)stack).ifPresent(art -> tooltip.add(I18n.func_135052_a((String)"jsonpaintings.itemTooltip", (Object[])new Object[]{I18n.func_135052_a((String)art.field_75702_A, (Object[])new Object[0]), art.field_75703_B >> 4, art.field_75704_C >> 4})));
    }

    @Nullable
    public String getCreatorModId(@Nonnull ItemStack stack) {
        ResourceLocation loc = this.getRegistryName();
        return loc != null ? IArtCapability.getOptional((ICapabilityProvider)stack).map(art -> JSONHandler.MODID_LOOKUP.getOrDefault(art, "forge")).orElseGet(() -> ((ResourceLocation)loc).func_110624_b()) : null;
    }

    @Nonnull
    protected IRarity getRarity(@Nonnull ItemStack stack, @Nonnull Predicate<IRarity> condition) {
        return IArtCapability.getOptional((ICapabilityProvider)stack).map(art -> {
            IRarity rarity = IJSONPainting.from(art).getRarity();
            return condition.test(rarity) ? rarity : (IJSONPainting.from(art).isCreative() ? EnumRarity.EPIC : EnumRarity.UNCOMMON);
        }).orElseGet(() -> super.func_77613_e(stack));
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack stack) {
        return this.getRarity(stack, Objects::nonNull);
    }

    @Nonnull
    public EnumRarity func_77613_e(@Nonnull ItemStack stack) {
        return (EnumRarity)this.getRarity(stack, rarity -> rarity instanceof EnumRarity);
    }
}

