/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.jsonpaintings.mod.common.compat.waila;

import com.google.common.base.Strings;
import git.jbredwards.jsonpaintings.mod.common.compat.waila.TTRenderComponent;
import git.jbredwards.jsonpaintings.mod.common.util.IJSONPainting;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.IWailaTooltipRenderer;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.config.FormattingConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.IRarity;

@WailaPlugin
public final class WailaHandler
implements IWailaPlugin {
    public void register(@Nonnull IWailaRegistrar registrar) {
        registrar.addConfig("jsonpaintings", "showMotive", true);
        registrar.addConfig("jsonpaintings", "showExclusive", true);
        registrar.addConfig("jsonpaintings", "showSneakToCapture", true);
        registrar.registerHeadProvider((IWailaEntityProvider)Provider.INSTANCE, EntityPainting.class);
        registrar.registerBodyProvider((IWailaEntityProvider)Provider.INSTANCE, EntityPainting.class);
        registrar.registerTailProvider((IWailaEntityProvider)Provider.INSTANCE, EntityPainting.class);
        registrar.registerTooltipRenderer("jsonpaintings:component", (IWailaTooltipRenderer)TTRenderComponent.INSTANCE);
    }

    static enum Provider implements IWailaEntityProvider
    {
        INSTANCE;


        @Nonnull
        public List<String> getWailaHead(@Nonnull Entity entity, @Nonnull List<String> currentTip, @Nonnull IWailaEntityAccessor accessor, @Nonnull IWailaConfigHandler config) {
            if (entity instanceof EntityPainting && !currentTip.isEmpty()) {
                EntityPainting.EnumArt art = ((EntityPainting)entity).field_70522_e;
                currentTip.set(currentTip.size() - 1, Optional.ofNullable(IJSONPainting.from(art).getRarity()).map(IRarity::getColor).orElseGet(() -> (IJSONPainting.from(art).isCreative() ? EnumRarity.EPIC : EnumRarity.UNCOMMON).getColor()) + currentTip.get(currentTip.size() - 1).split("\u00a7f")[1]);
            }
            return currentTip;
        }

        @Nonnull
        public List<String> getWailaBody(@Nonnull Entity entity, @Nonnull List<String> currentTip, @Nonnull IWailaEntityAccessor accessor, @Nonnull IWailaConfigHandler config) {
            if (entity instanceof EntityPainting) {
                EntityPainting.EnumArt art = ((EntityPainting)entity).field_70522_e;
                if (config.getConfig("showMotive")) {
                    currentTip.add(TTRenderComponent.toString((ITextComponent)new TextComponentTranslation("jsonpaintings.wailaMotive", new Object[]{new TextComponentTranslation(art.field_75702_A, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY))})));
                }
                currentTip.add("");
                if (!accessor.getPlayer().func_184812_l_() && !accessor.getPlayer().func_175149_v() && !IJSONPainting.from(art).alwaysCapture() && config.getConfig("showSneakToCapture")) {
                    currentTip.add(TTRenderComponent.toString(new TextComponentTranslation("jsonpaintings.wailaSneakToCapture", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN))));
                }
                if (IJSONPainting.from(art).isCreative() && config.getConfig("showExclusive")) {
                    currentTip.add(TTRenderComponent.toString((ITextComponent)new TextComponentTranslation("jsonpaintings.wailaExclusive", new Object[0])));
                }
            }
            return currentTip;
        }

        @Nonnull
        public List<String> getWailaTail(@Nonnull Entity entity, @Nonnull List<String> currentTip, @Nonnull IWailaEntityAccessor accessor, @Nonnull IWailaConfigHandler config) {
            if (entity instanceof EntityPainting && !Strings.isNullOrEmpty((String)FormattingConfig.modNameFormat)) {
                currentTip.remove(currentTip.size() - 1);
                currentTip.add(String.format(FormattingConfig.modNameFormat, IJSONPainting.from(((EntityPainting)entity).field_70522_e).getModNameOrDefault()));
            }
            return currentTip;
        }
    }
}

