/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.jsonpaintings.mod.common.capability;

import git.jbredwards.jsonpaintings.mod.JSONPaintings;
import git.jbredwards.jsonpaintings.mod.common.util.JSONHandler;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public interface IArtCapability {
    @CapabilityInject(value=IArtCapability.class)
    @Nonnull
    public static final Capability<IArtCapability> CAPABILITY = null;
    @Nonnull
    public static final ResourceLocation LOCATION = new ResourceLocation("jsonpaintings", "painting");

    @Nullable
    public EntityPainting.EnumArt getArt();

    public void setArt(@Nullable EntityPainting.EnumArt var1);

    @Nonnull
    public static Optional<EntityPainting.EnumArt> getOptional(@Nullable ICapabilityProvider provider) {
        return Optional.ofNullable(IArtCapability.get(provider)).map(IArtCapability::getArt);
    }

    @Nullable
    public static IArtCapability get(@Nullable ICapabilityProvider provider) {
        return provider != null && provider.hasCapability(CAPABILITY, null) ? (IArtCapability)provider.getCapability(CAPABILITY, null) : null;
    }

    @SubscribeEvent
    public static void attach(final @Nonnull AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == Items.field_151159_an) {
            event.addCapability(LOCATION, (ICapabilityProvider)new ICapabilitySerializable<NBTBase>(){
                @Nonnull
                final IArtCapability instance;
                {
                    this.instance = new Impl((ItemStack)event.getObject());
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == CAPABILITY;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(this.hasCapability(capability, facing) ? CAPABILITY.cast((Object)this.instance) : null);
                }

                @Nonnull
                public NBTBase serializeNBT() {
                    return CAPABILITY.writeNBT((Object)this.instance, null);
                }

                public void deserializeNBT(@Nonnull NBTBase nbt) {
                    CAPABILITY.readNBT((Object)this.instance, null, nbt);
                }
            });
        }
    }

    public static enum Storage implements Capability.IStorage<IArtCapability>
    {
        INSTANCE;


        @Nonnull
        public NBTBase writeNBT(@Nonnull Capability<IArtCapability> capability, @Nonnull IArtCapability instance, @Nullable EnumFacing side) {
            return new NBTTagByte(0);
        }

        public void readNBT(@Nonnull Capability<IArtCapability> capability, @Nonnull IArtCapability instance, @Nullable EnumFacing side, @Nullable NBTBase nbt) {
            EntityPainting.EnumArt art;
            if (nbt instanceof NBTTagString && (art = Storage.getFromTitle(((NBTTagString)nbt).func_150285_a_(), a -> {})) != null) {
                instance.setArt(art);
            }
        }

        @Nullable
        static EntityPainting.EnumArt getFromTitle(@Nonnull String title, @Nonnull Consumer<EntityPainting.EnumArt> mapper) {
            for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
                if (!art.field_75702_A.equals(title)) continue;
                return art;
            }
            EntityPainting.EnumArt mapped = JSONHandler.PAINTING_REMAPS.get(title);
            if (mapped != null) {
                mapper.accept(mapped);
                return mapped;
            }
            JSONPaintings.LOGGER.error("Painting with motive: \"" + title + "\" has been removed, resulting in lost data. This can be fixed by assigning it a mapping.");
            return null;
        }
    }

    public static class Impl
    implements IArtCapability {
        @Nonnull
        protected final ItemStack stack;

        public Impl(@Nonnull ItemStack stackIn) {
            this.stack = stackIn;
        }

        @Override
        @Nullable
        public EntityPainting.EnumArt getArt() {
            if (this.stack.func_77978_p() != null && this.stack.func_77978_p().func_150297_b(LOCATION.toString(), 8)) {
                EntityPainting.EnumArt art = Storage.getFromTitle(this.stack.func_77978_p().func_74779_i(LOCATION.toString()), a -> this.stack.func_77983_a(LOCATION.toString(), (NBTBase)new NBTTagString(a.field_75702_A)));
                if (art == null) {
                    this.setArt(null);
                } else {
                    return art;
                }
            }
            return null;
        }

        @Override
        public void setArt(@Nullable EntityPainting.EnumArt artIn) {
            if (artIn != null) {
                this.stack.func_77983_a(LOCATION.toString(), (NBTBase)new NBTTagString(artIn.field_75702_A));
            } else if (this.stack.func_77978_p() != null && this.stack.func_77978_p().func_150297_b(LOCATION.toString(), 8)) {
                this.stack.func_77978_p().func_82580_o(LOCATION.toString());
                if (this.stack.func_77978_p().func_82582_d()) {
                    this.stack.func_77982_d(null);
                }
            }
        }
    }
}

