/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.jsonpaintings.mod.client;

import git.jbredwards.jsonpaintings.mod.common.util.IJSONPainting;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPainting;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderJSONPainting
extends RenderPainting {
    public static boolean CALC_BRIGHTNESS = true;

    public RenderJSONPainting(@Nonnull RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void func_76986_a(@Nonnull EntityPainting entity, double x, double y, double z, float entityYaw, float partialTicks) {
        IJSONPainting painting = IJSONPainting.from(entity.field_70522_e);
        if (!painting.useSpecialRenderer()) {
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179091_B();
        this.func_180548_c((Entity)entity);
        GlStateManager.func_179139_a((double)0.0625, (double)0.0625, (double)0.0625);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        this.renderPainting(entity, painting);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        if (!this.field_188301_f) {
            this.func_177067_a((Entity)entity, x, y, z);
        }
    }

    protected void renderPainting(@Nonnull EntityPainting entity, @Nonnull IJSONPainting painting) {
        int front = this.getGlTextureId(painting.getFrontTexture());
        int back = this.getGlTextureId(painting.getBackTexture());
        int side = this.getGlTextureId(painting.getSideTexture());
        int width = entity.field_70522_e.field_75703_B >> 4;
        int height = entity.field_70522_e.field_75704_C >> 4;
        int centerX = -entity.field_70522_e.field_75703_B >> 1;
        int centerY = -entity.field_70522_e.field_75704_C >> 1;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                float minX = centerX + (x << 4);
                float maxX = centerX + (x + 1 << 4);
                float minY = centerY + (y << 4);
                float maxY = centerY + (y + 1 << 4);
                this.func_77008_a(entity, (maxX + minX) / 2.0f, (maxY + minY) / 2.0f);
                float frontMinU = (float)(width - x) / (float)width;
                float frontMaxU = (float)(width - x - 1) / (float)width;
                float frontMinV = (float)(height - y) / (float)height;
                float frontMaxV = (float)(height - y - 1) / (float)height;
                GlStateManager.func_179144_i((int)front);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                buffer.func_181662_b((double)maxX, (double)minY, -0.5).func_187315_a((double)frontMaxU, (double)frontMinV).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)minX, (double)minY, -0.5).func_187315_a((double)frontMinU, (double)frontMinV).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)minX, (double)maxY, -0.5).func_187315_a((double)frontMinU, (double)frontMaxV).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                buffer.func_181662_b((double)maxX, (double)maxY, -0.5).func_187315_a((double)frontMaxU, (double)frontMaxV).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                float backMinU = painting.hasBackTexture() ? frontMinU : 1.0f;
                float backMaxU = painting.hasBackTexture() ? frontMaxU : 0.0f;
                float backMinV = painting.hasBackTexture() ? frontMinV : 1.0f;
                float backMaxV = painting.hasBackTexture() ? frontMaxV : 0.0f;
                GlStateManager.func_179144_i((int)back);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                buffer.func_181662_b((double)maxX, (double)maxY, 0.5).func_187315_a((double)backMaxU, (double)backMaxV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                buffer.func_181662_b((double)minX, (double)maxY, 0.5).func_187315_a((double)backMinU, (double)backMaxV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                buffer.func_181662_b((double)minX, (double)minY, 0.5).func_187315_a((double)backMinU, (double)backMinV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                buffer.func_181662_b((double)maxX, (double)minY, 0.5).func_187315_a((double)backMaxU, (double)backMinV).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                float sideMinU = painting.hasSideTexture() ? frontMinU : 1.0f;
                float sideMaxU = painting.hasSideTexture() ? frontMaxU : 0.0f;
                float sideMinV = painting.hasSideTexture() ? frontMinV : 1.0f;
                float sideMaxV = painting.hasSideTexture() ? frontMaxV : 0.0f;
                float sideWidth = painting.hasSideTexture() ? 1.0f / (float)entity.field_70522_e.field_75703_B : 0.0625f;
                float sideHeight = painting.hasSideTexture() ? 1.0f / (float)entity.field_70522_e.field_75704_C : 0.0625f;
                boolean drawSide = false;
                if (y + 1 == height) {
                    drawSide = true;
                    GlStateManager.func_179144_i((int)side);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                    buffer.func_181662_b((double)maxX, (double)maxY, -0.5).func_187315_a((double)sideMaxU, (double)sideHeight).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)minX, (double)maxY, -0.5).func_187315_a((double)sideMinU, (double)sideHeight).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)minX, (double)maxY, 0.5).func_187315_a((double)sideMinU, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)maxX, (double)maxY, 0.5).func_187315_a((double)sideMaxU, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                }
                if (y == 0) {
                    if (!drawSide) {
                        drawSide = true;
                        GlStateManager.func_179144_i((int)side);
                        buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                    }
                    buffer.func_181662_b((double)maxX, (double)minY, 0.5).func_187315_a((double)sideMaxU, 1.0).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)minX, (double)minY, 0.5).func_187315_a((double)sideMinU, 1.0).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)minX, (double)minY, -0.5).func_187315_a((double)sideMinU, (double)(1.0f - sideHeight)).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)maxX, (double)minY, -0.5).func_187315_a((double)sideMaxU, (double)(1.0f - sideHeight)).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                }
                if (x == 0) {
                    if (!drawSide) {
                        drawSide = true;
                        GlStateManager.func_179144_i((int)side);
                        buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                    }
                    buffer.func_181662_b((double)minX, (double)maxY, -0.5).func_187315_a((double)(1.0f - sideWidth), (double)sideMaxV).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)minX, (double)minY, -0.5).func_187315_a((double)(1.0f - sideWidth), (double)sideMinV).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)minX, (double)minY, 0.5).func_187315_a(1.0, (double)sideMinV).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)minX, (double)maxY, 0.5).func_187315_a(1.0, (double)sideMaxV).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                }
                if (x + 1 == width) {
                    if (!drawSide) {
                        drawSide = true;
                        GlStateManager.func_179144_i((int)side);
                        buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                    }
                    buffer.func_181662_b((double)maxX, (double)maxY, 0.5).func_187315_a(0.0, (double)sideMaxV).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)maxX, (double)minY, 0.5).func_187315_a(0.0, (double)sideMinV).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)maxX, (double)minY, -0.5).func_187315_a((double)sideWidth, (double)sideMinV).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    buffer.func_181662_b((double)maxX, (double)maxY, -0.5).func_187315_a((double)sideWidth, (double)sideMaxV).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                }
                if (!drawSide) continue;
                Tessellator.func_178181_a().func_78381_a();
            }
        }
    }

    protected int getGlTextureId(@Nonnull ResourceLocation location) {
        ITextureObject texture = this.field_76990_c.field_78724_e.func_110581_b(location);
        if (texture == null) {
            texture = new SimpleTexture(location);
            this.field_76990_c.field_78724_e.func_110579_a(location, texture);
        }
        return texture.func_110552_b();
    }

    public void func_77008_a(@Nonnull EntityPainting painting, float x, float y) {
        if (CALC_BRIGHTNESS) {
            super.func_77008_a(painting, x, y);
        } else {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
    }
}

