/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.jsonpaintings.mod.asm.transformer;

import git.jbredwards.jsonpaintings.api.event.PaintingUpdateEvent;
import git.jbredwards.jsonpaintings.mod.JSONPaintings;
import git.jbredwards.jsonpaintings.mod.common.capability.IArtCapability;
import git.jbredwards.jsonpaintings.mod.common.util.IJSONPainting;
import git.jbredwards.jsonpaintings.mod.common.util.JSONHandler;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class EntityPaintingTransformer
implements IClassTransformer,
Opcodes {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        if ("net.minecraft.entity.item.EntityPainting".equals(transformedName)) {
            ClassNode classNode = new ClassNode();
            new ClassReader(basicClass).accept((ClassVisitor)classNode, 4);
            block0: for (MethodNode method : classNode.methods) {
                if (method.name.equals("<init>") && method.desc.equals("(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)V")) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (insn.getOpcode() != 184 || !((MethodInsnNode)insn).owner.equals("net/minecraft/entity/item/EntityPainting$EnumArt")) continue;
                        ((MethodInsnNode)insn).owner = "git/jbredwards/jsonpaintings/mod/asm/transformer/EntityPaintingTransformer$Hooks";
                        continue block0;
                    }
                    continue;
                }
                if (method.name.equals(FMLLaunchHandler.isDeobfuscatedEnvironment() ? "readEntityFromNBT" : "func_70037_a")) {
                    for (AbstractInsnNode insn : method.instructions.toArray()) {
                        if (insn.getOpcode() != 178 || !((FieldInsnNode)insn).name.equals("KEBAB")) continue;
                        method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
                        method.instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/jsonpaintings/mod/asm/transformer/EntityPaintingTransformer$Hooks", "remap", "(Ljava/lang/String;Lnet/minecraft/entity/item/EntityPainting$EnumArt;)Lnet/minecraft/entity/item/EntityPainting$EnumArt;", false));
                        continue block0;
                    }
                    continue;
                }
                if (!method.name.equals(FMLLaunchHandler.isDeobfuscatedEnvironment() ? "onBroken" : "func_110128_b")) continue;
                for (AbstractInsnNode insn : method.instructions.toArray()) {
                    if (insn.getOpcode() != 11) continue;
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/jsonpaintings/mod/asm/transformer/EntityPaintingTransformer$Hooks", "applyArt", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/item/EntityPainting;Lnet/minecraft/entity/Entity;)Lnet/minecraft/item/ItemStack;", false));
                    break block0;
                }
            }
            MethodNode getPickedResult = new MethodNode(1, "getPickedResult", "(Lnet/minecraft/util/math/RayTraceResult;)Lnet/minecraft/item/ItemStack;", null, null);
            getPickedResult.visitVarInsn(25, 0);
            getPickedResult.visitMethodInsn(184, "git/jbredwards/jsonpaintings/mod/asm/transformer/EntityPaintingTransformer$Hooks", "getPickedResult", "(Lnet/minecraft/entity/item/EntityPainting;)Lnet/minecraft/item/ItemStack;", false);
            getPickedResult.visitInsn(176);
            getPickedResult.visitMaxs(1, 2);
            classNode.methods.add(getPickedResult);
            MethodNode onUpdate = new MethodNode(1, FMLLaunchHandler.isDeobfuscatedEnvironment() ? "onUpdate" : "func_70071_h_", "()V", null, null);
            onUpdate.visitVarInsn(25, 0);
            onUpdate.visitMethodInsn(184, "git/jbredwards/jsonpaintings/mod/asm/transformer/EntityPaintingTransformer$Hooks", "onUpdatePainting", "(Lnet/minecraft/entity/item/EntityPainting;)Z", false);
            LabelNode label = new LabelNode();
            onUpdate.instructions.add((AbstractInsnNode)new JumpInsnNode(153, label));
            onUpdate.visitInsn(177);
            onUpdate.instructions.add((AbstractInsnNode)label);
            onUpdate.visitFrame(3, 0, null, 0, null);
            onUpdate.visitVarInsn(25, 0);
            onUpdate.visitMethodInsn(183, "net/minecraft/entity/EntityHanging", FMLLaunchHandler.isDeobfuscatedEnvironment() ? "onUpdate" : "func_70071_h_", "()V", false);
            onUpdate.visitInsn(177);
            onUpdate.visitMaxs(1, 2);
            classNode.methods.add(onUpdate);
            ClassWriter writer = new ClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static final class Hooks {
        @Nonnull
        public static ItemStack applyArt(@Nonnull ItemStack stack, @Nonnull EntityPainting painting, @Nullable Entity breaker) {
            IArtCapability cap;
            if ((breaker instanceof EntityPlayer && breaker.func_70093_af() || IJSONPainting.from(painting.field_70522_e).alwaysCapture()) && (cap = IArtCapability.get((ICapabilityProvider)stack)) != null) {
                cap.setArt(painting.field_70522_e);
            }
            return stack;
        }

        @Nonnull
        public static EntityPainting.EnumArt[] values() {
            EntityPainting.EnumArt[] values = (EntityPainting.EnumArt[])Arrays.stream(EntityPainting.EnumArt.values()).filter(art -> !IJSONPainting.from(art).isCreative()).toArray(EntityPainting.EnumArt[]::new);
            if (values.length == 0) {
                throw new IllegalStateException("Attempted to place painting entity with no valid art values! Please ensure there is at least one 1x1 art type with \"isCreative\" set to false.");
            }
            return values;
        }

        @Nonnull
        public static ItemStack getPickedResult(@Nonnull EntityPainting entity) {
            IArtCapability cap;
            ItemStack stack = new ItemStack(Items.field_151159_an);
            if (GuiScreen.func_146271_m() && (cap = IArtCapability.get((ICapabilityProvider)stack)) != null) {
                cap.setArt(entity.field_70522_e);
            }
            return stack;
        }

        public static boolean onUpdatePainting(@Nonnull EntityPainting painting) {
            return MinecraftForge.EVENT_BUS.post((Event)new PaintingUpdateEvent(painting));
        }

        @Nonnull
        public static EntityPainting.EnumArt remap(@Nonnull String motive, @Nonnull EntityPainting.EnumArt fallback) {
            EntityPainting.EnumArt mapped = JSONHandler.PAINTING_REMAPS.get(motive);
            if (mapped != null) {
                return mapped;
            }
            JSONPaintings.LOGGER.error("Painting with motive: \"" + motive + "\" has been removed, resulting in lost data. This can be fixed by assigning it a mapping.");
            return fallback;
        }
    }
}

