/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.jsonpaintings.mod;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import git.jbredwards.jsonpaintings.mod.asm.ASMHandler;
import git.jbredwards.jsonpaintings.mod.client.PaintingsResourcePack;
import git.jbredwards.jsonpaintings.mod.client.RenderJSONPainting;
import git.jbredwards.jsonpaintings.mod.common.capability.IArtCapability;
import git.jbredwards.jsonpaintings.mod.common.commands.CommandJSONPaintings;
import git.jbredwards.jsonpaintings.mod.common.compat.top.TOPHandler;
import git.jbredwards.jsonpaintings.mod.common.util.IJSONPainting;
import git.jbredwards.jsonpaintings.mod.common.util.JSONHandler;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.entity.item.EntityPainting;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DependencyParser;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JSONPaintings
extends DummyModContainer {
    @Nonnull
    public static final String MODID = "jsonpaintings";
    @Nonnull
    public static final String NAME = "JSON Paintings";
    @Nonnull
    public static final String VERSION = "1.4.0";
    @Nonnull
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"JSON Paintings");
    @Nullable
    private static String creditsKey;
    @Nullable
    private static String descKey;
    public static boolean IS_PSG_INSTALLED;
    public static boolean IS_JEI_INSTALLED;

    public JSONPaintings() {
        super(new ModMetadata());
        this.getMetadata().modId = MODID;
        this.getMetadata().name = NAME;
        this.getMetadata().version = VERSION;
        this.getMetadata().url = "https://github.com/jbredwards/JSON-Paintings-Mod";
        this.getMetadata().authorList = Collections.singletonList("jbredwards");
        this.getMetadata().credits = "mod.jsonpaintings.credits";
        this.getMetadata().description = "mod.jsonpaintings.description";
        this.getMetadata().logoFile = "logo.png";
        this.getMetadata().dependencies.addAll(new DependencyParser((String)this.getModId(), (Side)FMLCommonHandler.instance().getSide()).parseDependencies((String)"after:jei@[4.15.0.276,);").dependencies);
    }

    public boolean registerBus(@Nonnull EventBus bus, @Nonnull LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Nonnull
    public File getSource() {
        return ASMHandler.modLocation;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Class<?> getCustomResourcePackClass() {
        return PaintingsResourcePack.class;
    }

    @Subscribe
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(IArtCapability.class, (Capability.IStorage)IArtCapability.Storage.INSTANCE, () -> {
            throw new UnsupportedOperationException();
        });
        MinecraftForge.EVENT_BUS.register(IArtCapability.class);
        IS_PSG_INSTALLED = Loader.isModLoaded((String)"paintingselgui");
        IS_JEI_INSTALLED = Loader.isModLoaded((String)"jei");
    }

    @SideOnly(value=Side.CLIENT)
    @Subscribe
    public void preInitClient(@Nonnull FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityPainting.class, RenderJSONPainting::new);
    }

    @Subscribe
    public void init(@Nonnull FMLInitializationEvent event) {
        if (Loader.isModLoaded((String)"theoneprobe")) {
            TOPHandler.initialize();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Subscribe
    public void initClient(@Nonnull FMLInitializationEvent event) {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)((ISelectiveResourceReloadListener)(manager, condition) -> {
            if (condition.test(VanillaResourceType.LANGUAGES) && this.getMetadata() != null) {
                this.getMetadata().credits = I18n.func_135052_a((String)(creditsKey == null ? (creditsKey = this.getMetadata().credits) : creditsKey), (Object[])new Object[0]).replace("\\n", "\n");
                this.getMetadata().description = I18n.func_135052_a((String)(descKey == null ? (descKey = this.getMetadata().description) : descKey), (Object[])new Object[0]);
            }
        }));
    }

    @Subscribe
    public void postInit(@Nonnull FMLPostInitializationEvent event) throws Exception {
        JSONHandler.readMods();
        JSONHandler.readInstance(false);
        for (int i = 0; i < 26; ++i) {
            JSONHandler.MODID_LOOKUP.put(EntityPainting.EnumArt.values()[i], "minecraft");
            IJSONPainting.from(EntityPainting.EnumArt.values()[i]).setModName("Minecraft");
        }
    }

    @Subscribe
    public void serverStarting(@Nonnull FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandJSONPaintings());
        event.registerServerCommand((ICommand)new CommandJSONPaintings.Trimmed());
    }

    @Nonnull
    public List<ArtifactVersion> getDependencies() {
        return this.getMetadata().dependencies;
    }
}

