/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.common.network;

import dev.satyrn.wolfarmor.WolfArmorMod;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class MessageBase<T extends MessageBase<T>>
implements IMessage,
IMessageHandler<T, IMessage> {
    protected abstract void read(PacketBuffer var1) throws IOException;

    protected abstract void write(PacketBuffer var1) throws IOException;

    @Nullable
    protected abstract IMessage process(EntityPlayer var1, Side var2);

    protected boolean isSideValid(Side side) {
        return true;
    }

    @Deprecated
    protected boolean isMainThreadRequired() {
        return this.isScheduled();
    }

    protected boolean isScheduled() {
        return true;
    }

    public final IMessage onMessage(T message, MessageContext context) {
        if (!this.isSideValid(context.side)) {
            throw new RuntimeException(String.format("The side %s is not valid for packet %s", context.side.name(), message.getClass().getSimpleName()));
        }
        if (this.isScheduled()) {
            this.enqueue(message, context);
            return null;
        }
        return ((MessageBase)message).process(WolfArmorMod.getProxy().getPlayerFromContext(context), context.side);
    }

    private void enqueue(T message, MessageContext context) {
        IThreadListener thread = WolfArmorMod.getProxy().getThreadFromContext(context);
        thread.func_152344_a(new Runnable((MessageBase)message, context){
            final /* synthetic */ MessageBase val$message;
            final /* synthetic */ MessageContext val$context;
            {
                this.val$message = messageBase;
                this.val$context = messageContext;
            }

            @Override
            public void run() {
                this.val$message.process(WolfArmorMod.getProxy().getPlayerFromContext(this.val$context), this.val$context.side);
            }
        });
    }

    public final void fromBytes(ByteBuf buf) {
        try {
            this.read(new PacketBuffer(buf));
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("The packet %s failed to deserialize.", this.getClass().getSimpleName()), ex);
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            this.write(new PacketBuffer(buf));
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("The packet %s failed to serialize.", this.getClass().getSimpleName()), ex);
        }
    }

    public static abstract class ServerMessageBase<T extends ServerMessageBase<T>>
    extends MessageBase<T> {
        @Override
        protected final boolean isSideValid(Side side) {
            return side.isServer();
        }
    }

    public static abstract class ClientMessageBase<T extends ClientMessageBase<T>>
    extends MessageBase<T> {
        @Override
        protected final boolean isSideValid(Side side) {
            return side.isClient();
        }
    }
}

