/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.formatting;

import crafttweaker.api.formatting.IFormattedText;
import crafttweaker.api.text.ITextComponent;
import crafttweaker.mc1120.formatting.FormattedStringJoin;
import crafttweaker.mc1120.formatting.IMCFormattedString;
import crafttweaker.mc1120.text.expand.ExpandTextComponent;
import net.minecraft.util.text.TextFormatting;

public class FormattedMarkupString
implements IMCFormattedString {
    private final TextFormatting markup;
    private final IMCFormattedString contents;

    public FormattedMarkupString(TextFormatting markup, IMCFormattedString contents) {
        this.markup = markup;
        this.contents = contents;
    }

    @Override
    public String getTooltipString() {
        return this.markup + this.contents.getTooltipString(this.markup.toString());
    }

    @Override
    public String getTooltipString(String context) {
        return this.markup + this.contents.getTooltipString(context + this.markup);
    }

    @Override
    public IFormattedText add(IFormattedText other) {
        return this.cat(other);
    }

    @Override
    public IFormattedText cat(IFormattedText other) {
        return new FormattedStringJoin(this, (IMCFormattedString)other);
    }

    @Override
    public String getText() {
        return this.getTooltipString();
    }

    @Override
    public ITextComponent asTextComponent() {
        ITextComponent textComponent = ExpandTextComponent.fromString(this.getText());
        textComponent.getStyle().setColor(this.markup.name());
        return textComponent;
    }
}

