/*
 * Decompiled with CFR 0.152.
 */
package citpatch;

import citpatch.mixin.optifine.CustomItemsAccessor;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.registries.GameData;
import net.optifine.CustomItemProperties;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;

public class RemappingHandler {
    private static final Map<Integer, Integer> enchIdOriginalMap = new HashMap<Integer, Integer>();

    public static void remap(FMLModIdMappingEvent event) {
        Map<Integer, Integer> enchIdMap;
        if (!event.isFrozen) {
            ImmutableList enchIdRemappings = event.getRemaps(GameData.ENCHANTMENTS);
            if (enchIdRemappings == null || enchIdRemappings.isEmpty()) {
                return;
            }
            enchIdMap = enchIdRemappings.stream().collect(Collectors.toMap(remap -> remap.oldId, remap -> remap.newId));
            enchIdMap.forEach((oldId, newId) -> enchIdOriginalMap.put((Integer)newId, (Integer)oldId));
        } else {
            enchIdMap = enchIdOriginalMap;
            if (enchIdOriginalMap.isEmpty()) {
                return;
            }
        }
        CustomItemProperties[][] allItemCITs = CustomItemsAccessor.getItemProperties();
        if (allItemCITs == null || allItemCITs.length == 0) {
            return;
        }
        for (CustomItemProperties[] itemCITs : allItemCITs) {
            if (itemCITs == null || itemCITs.length == 0) continue;
            for (CustomItemProperties cit : itemCITs) {
                if (cit.enchantmentIds == null || cit.enchantmentIds.getCountRanges() == 0) continue;
                HashSet<Integer> newEnchIds = new HashSet<Integer>();
                for (int oldIntRangeIndex = 0; oldIntRangeIndex < cit.enchantmentIds.getCountRanges(); ++oldIntRangeIndex) {
                    RangeInt oldRange = cit.enchantmentIds.getRange(oldIntRangeIndex);
                    for (int oldEnchIdIndex = oldRange.getMin(); oldEnchIdIndex <= oldRange.getMax(); ++oldEnchIdIndex) {
                        newEnchIds.add(enchIdMap.getOrDefault(oldEnchIdIndex, oldEnchIdIndex));
                    }
                }
                if (newEnchIds.size() == 1) {
                    int enchId = newEnchIds.stream().findFirst().orElse(-1);
                    if (enchId == -1) continue;
                    cit.enchantmentIds = new RangeListInt(new RangeInt(enchId, enchId));
                    continue;
                }
                if (newEnchIds.size() <= 1) continue;
                List sortedNewIds = newEnchIds.stream().sorted().collect(Collectors.toList());
                RangeListInt newRangeList = new RangeListInt();
                int currEnchIdRangeStart = -1;
                for (int i = 0; i < sortedNewIds.size(); ++i) {
                    int currEnchId = (Integer)sortedNewIds.get(i);
                    if (currEnchIdRangeStart == -1) {
                        currEnchIdRangeStart = currEnchId;
                    }
                    if (i != sortedNewIds.size() - 1 && (Integer)sortedNewIds.get(i + 1) == currEnchId + 1) continue;
                    newRangeList.addRange(new RangeInt(currEnchIdRangeStart, currEnchId));
                    currEnchIdRangeStart = -1;
                }
                cit.enchantmentIds = newRangeList;
            }
        }
        if (event.isFrozen) {
            enchIdOriginalMap.clear();
        }
    }
}

