/*
 * Decompiled with CFR 0.152.
 */
package citpatch;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="optifinecitpatch")
@MixinConfig(name="optifinecitpatch")
public class ConfigHandler {
    @Config.Comment(value={"Enchanted Books will not have Enchantment Glint if set to true."})
    @Config.Name(value="Remove Glint")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.optifinecitpatch.glint.json", defaultValue=false)
    public static boolean removeGlint = false;
    @Config.Comment(value={"Will not spam the startup log with one line per registered CIT if enabled."})
    @Config.Name(value="Remove Log Spam")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.optifinecitpatch.logspam.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="optifine", desired=true, reason="Mod not needed without optifine, auto-disabling", warnIngame=false)
    public static boolean removeLogSpam = true;
    @Config.Comment(value={"Will only render a CIT for the first enchant on a book with multiple enchantments."})
    @Config.Name(value="Only First Enchant")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.optifinecitpatch.firstenchant.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="optifine", desired=true, reason="Mod not needed without optifine, auto-disabling", warnIngame=false)
    public static boolean onlyFirstEnchant = true;
    @Config.Comment(value={"Fixes CITs breaking completely if an enchantment couldn't be found."})
    @Config.Name(value="Fix Missing Enchantment")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.optifinecitpatch.fixmissing.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="optifine", desired=true, reason="Mod not needed without optifine, auto-disabling", warnIngame=false)
    public static boolean fixMissingEnchantment = true;
    @Config.Comment(value={"Some ids can change when players load into worlds that have different id mappings. This will reload CITs on login to show them correctly."})
    @Config.Name(value="Reload CITs on Login")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.optifinecitpatch.reloadonlogin.json", defaultValue=true)
    @MixinConfig.CompatHandling(modid="optifine", desired=true, reason="Mod not needed without optifine, auto-disabling", warnIngame=false)
    public static boolean reloadOnLogin = true;

    @Mod.EventBusSubscriber(modid="optifinecitpatch")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("optifinecitpatch")) {
                ConfigManager.sync((String)"optifinecitpatch", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

