/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.wrapper;

import fermiummixins.handlers.ConfigHandler;
import java.util.HashMap;
import java.util.Map;
import ladysnake.spawnercontrol.controlledspawner.CapabilityControllableSpawner;
import ladysnake.spawnercontrol.controlledspawner.IControllableSpawner;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class SpawnerControlWrapper {
    private static final String NBT_TAG_SPAWNER_POS = "spawnercontrol:spawnerPos";
    private static final Map<Integer, Map<Long, Integer>> brokenSpawnerMobCounter = new HashMap<Integer, Map<Long, Integer>>();

    public static void increaseSpawnerCount(Entity entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound data = entity.getEntityData();
        if (data.func_74764_b(NBT_TAG_SPAWNER_POS)) {
            World world;
            long spawnerPos;
            NBTBase nbt = entity.getEntityData().func_74781_a(NBT_TAG_SPAWNER_POS);
            if (nbt instanceof NBTTagCompound) {
                spawnerPos = ((NBTTagCompound)nbt).func_74763_f("pos");
                world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(((NBTTagCompound)nbt).func_74762_e("dimension"));
            } else if (nbt instanceof NBTTagLong) {
                spawnerPos = ((NBTTagLong)nbt).func_150291_c();
                world = entity.func_130014_f_();
            } else {
                return;
            }
            TileEntity tile = world.func_175625_s(BlockPos.func_177969_a((long)spawnerPos));
            if (tile instanceof TileEntityMobSpawner) {
                IControllableSpawner handler = CapabilityControllableSpawner.getHandler((TileEntityMobSpawner)((TileEntityMobSpawner)tile));
                if (handler.getConfig().incrementOnMobDeath && handler.incrementSpawnedMobsCount()) {
                    SpawnerControlWrapper.registerBrokenSpawner(world.field_73011_w.getDimension(), spawnerPos);
                }
                if (SpawnerControlWrapper.isBrokenSpawnerRegistered(world.field_73011_w.getDimension(), spawnerPos)) {
                    SpawnerControlWrapper.incrementBrokenSpawner(world.field_73011_w.getDimension(), spawnerPos);
                }
            } else {
                SpawnerControlWrapper.incrementBrokenSpawner(world.field_73011_w.getDimension(), spawnerPos);
            }
        }
    }

    public static void registerBrokenSpawner(int dimId, long spawnerPos) {
        if (!ConfigHandler.SPAWNERCONTROL_CONFIG.spawnerFarmingFix) {
            return;
        }
        brokenSpawnerMobCounter.computeIfAbsent(dimId, k -> new HashMap());
        brokenSpawnerMobCounter.get(dimId).putIfAbsent(spawnerPos, 0);
    }

    private static boolean isBrokenSpawnerRegistered(int dimId, long spawnerPos) {
        if (brokenSpawnerMobCounter.get(dimId) != null) {
            return brokenSpawnerMobCounter.get(dimId).get(spawnerPos) != null;
        }
        return false;
    }

    private static void incrementBrokenSpawner(int dimId, long spawnerPos) {
        if (!ConfigHandler.SPAWNERCONTROL_CONFIG.spawnerFarmingFix) {
            return;
        }
        brokenSpawnerMobCounter.computeIfAbsent(dimId, k -> new HashMap());
        Map<Long, Integer> dimMap = brokenSpawnerMobCounter.get(dimId);
        Integer deadCount = dimMap.get(spawnerPos);
        if (deadCount == null) {
            deadCount = ConfigHandler.SPAWNERCONTROL_CONFIG.spawnerFarmingFixThreshold;
        }
        dimMap.put(spawnerPos, deadCount + 1);
    }

    public static boolean shouldCancelDrops(Entity entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (!ConfigHandler.SPAWNERCONTROL_CONFIG.spawnerFarmingFix) {
            return false;
        }
        NBTTagCompound data = entity.getEntityData();
        if (data.func_74764_b(NBT_TAG_SPAWNER_POS)) {
            Integer deadCount;
            World world;
            long spawnerPos;
            NBTBase nbt = entity.getEntityData().func_74781_a(NBT_TAG_SPAWNER_POS);
            if (nbt instanceof NBTTagCompound) {
                spawnerPos = ((NBTTagCompound)nbt).func_74763_f("pos");
                world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(((NBTTagCompound)nbt).func_74762_e("dimension"));
            } else if (nbt instanceof NBTTagLong) {
                spawnerPos = ((NBTTagLong)nbt).func_150291_c();
                world = entity.func_130014_f_();
            } else {
                return true;
            }
            Map<Long, Integer> dimMap = brokenSpawnerMobCounter.get(world.field_73011_w.getDimension());
            if (dimMap != null && (deadCount = dimMap.get(spawnerPos)) != null) {
                return deadCount > ConfigHandler.SPAWNERCONTROL_CONFIG.spawnerFarmingFixThreshold;
            }
        }
        return false;
    }

    public static void clearSpawnerMap(int dimension) {
        brokenSpawnerMobCounter.remove(dimension);
    }
}

