/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.wrapper;

import com.google.common.collect.Lists;
import fermiummixins.wrapper.IBlockStateIdentity;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ObjectIntIdentityMap;

public abstract class BlockStateIdentityPatchWrapper {
    private static int currentID = 0;

    public static int getNewID() {
        return currentID++;
    }

    public static class ClearableObjectIntIdentityMapPatched
    extends ObjectIntIdentityMap<IBlockState> {
        private final ArrayList<Integer> identityArray;
        private int size = 0;

        public ClearableObjectIntIdentityMapPatched() {
            this(65536);
        }

        public ClearableObjectIntIdentityMapPatched(int expectedSize) {
            super(expectedSize);
            this.identityArray = Lists.newArrayListWithExpectedSize((int)expectedSize);
        }

        public void put(IBlockState key, int value) {
            if (key == null) {
                return;
            }
            int fixKey = ((IBlockStateIdentity)key).fermiummixins$getIdentityKey();
            while (this.identityArray.size() <= fixKey) {
                this.identityArray.add(null);
            }
            if (this.identityArray.set(fixKey, value) == null) {
                ++this.size;
            }
            while (this.field_148748_b.size() <= value) {
                this.field_148748_b.add(null);
            }
            this.field_148748_b.set(value, key);
        }

        public int get(@Nullable IBlockState key) {
            if (key == null) {
                return -1;
            }
            Integer integer = this.get(((IBlockStateIdentity)key).fermiummixins$getIdentityKey());
            if (integer == null) {
                integer = this.get(key.func_177230_c().func_176203_a(key.func_177230_c().func_176201_c(key)));
            }
            return integer;
        }

        private Integer get(int key) {
            if (key >= this.identityArray.size()) {
                return null;
            }
            return this.identityArray.get(key);
        }

        public int func_186804_a() {
            return this.size;
        }

        public void clear() {
            this.field_148748_b.clear();
            this.identityArray.clear();
            this.size = 0;
        }

        public void remove(IBlockState key) {
            if (key == null) {
                return;
            }
            int fixKey = ((IBlockStateIdentity)key).fermiummixins$getIdentityKey();
            Integer prev = this.get(fixKey);
            if (prev != null) {
                this.identityArray.set(fixKey, null);
                this.field_148748_b.set(prev, null);
                --this.size;
            }
        }
    }
}

