/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.mixin.waystones;

import fermiummixins.handlers.ConfigHandler;
import fermiummixins.mixin.waystones.vanilla.IBiomeAccessor;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.util.GenerateWaystoneNameEvent;
import net.blay09.mods.waystones.worldgen.NameGenerator;
import net.blay09.mods.waystones.worldgen.RomanNumber;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={NameGenerator.class})
public abstract class NameGeneratorMixin
extends WorldSavedData {
    @Shadow(remap=false)
    private Map<String, String> BIOME_NAMES;
    @Unique
    private final Object2IntMap<String> fermiummixins$usedNamesMap = new Object2IntOpenHashMap();

    @Shadow(remap=false)
    public abstract void init();

    @Shadow(remap=false)
    protected abstract String randomName(Random var1);

    public NameGeneratorMixin(String name) {
        super(name);
    }

    @Overwrite(remap=false)
    public String getName(BlockPos pos, int dimension, Biome biome, Random rand) {
        if (this.BIOME_NAMES == null) {
            this.init();
        }
        String baseName = null;
        String name = null;
        List<String> customNames = Arrays.asList(WaystoneConfig.worldGen.customNames);
        Collections.shuffle(customNames);
        for (String tryName : customNames) {
            if (this.fermiummixins$usedNamesMap.containsKey((Object)tryName)) continue;
            baseName = name = tryName;
            break;
        }
        int count = 0;
        if (name == null) {
            Block block;
            WorldServer world;
            boolean isVillage = false;
            if (ConfigHandler.WAYSTONES_CONFIG.villageWaystoneRemoveBiome && (world = DimensionManager.getWorld((int)dimension)) != null && !world.field_72995_K && (block = world.func_180495_p(pos.func_177977_b()).func_177230_c()) == Blocks.field_150426_aN) {
                isVillage = true;
            }
            String biomeSuffix = isVillage ? null : this.BIOME_NAMES.get(((IBiomeAccessor)biome).getBiomeName());
            baseName = name = this.randomName(rand) + (biomeSuffix != null ? " " + biomeSuffix : "");
            count = this.fermiummixins$usedNamesMap.getInt((Object)name);
            if (count > 0) {
                name = name + " " + RomanNumber.toRoman((int)count);
            }
        }
        GenerateWaystoneNameEvent event = new GenerateWaystoneNameEvent(pos, dimension, name);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!Objects.equals(name, event.getWaystoneName())) {
            baseName = name = event.getWaystoneName();
            count = this.fermiummixins$usedNamesMap.getInt((Object)name);
        }
        this.fermiummixins$usedNamesMap.put((Object)baseName, count + 1);
        this.func_76185_a();
        return name;
    }

    @Overwrite
    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList tagList = compound.func_150295_c("UsedNamesMap", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound comp = tagList.func_150305_b(i);
            this.fermiummixins$usedNamesMap.put((Object)comp.func_74779_i("Name"), comp.func_74762_e("Val"));
        }
    }

    @Overwrite
    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry entry : this.fermiummixins$usedNamesMap.entrySet()) {
            NBTTagCompound comp = new NBTTagCompound();
            comp.func_74778_a("Name", (String)entry.getKey());
            comp.func_74768_a("Val", ((Integer)entry.getValue()).intValue());
            tagList.func_74742_a((NBTBase)comp);
        }
        compound.func_74782_a("UsedNamesMap", (NBTBase)tagList);
        return compound;
    }
}

