/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.mixin.vanilla;

import fermiummixins.handlers.ConfigHandler;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={WorldProvider.class})
public abstract class WorldProvider_RespawnProtectionMixin {
    @Shadow
    protected World field_76579_a;

    @Inject(method={"getRandomizedSpawnPoint"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getTopSolidOrLiquidBlock(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/BlockPos;")}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void fermiummixins_vanillaWorldProvider_getRandomizedSpawnPoint_inject(CallbackInfoReturnable<BlockPos> cir, BlockPos ret, boolean isAdventure, int spawnFuzz, int border, int spawnFuzzHalf) {
        for (int i = 0; i < ConfigHandler.VANILLA_CONFIG.respawnProtectionAttempts; ++i) {
            BlockPos attempt = ret.func_177982_a(spawnFuzzHalf - this.field_76579_a.field_73012_v.nextInt(spawnFuzz), 0, spawnFuzzHalf - this.field_76579_a.field_73012_v.nextInt(spawnFuzz));
            BlockPos returnable = WorldProvider_RespawnProtectionMixin.fermiummixins$getOrAttemptTopSolidBlock(this.field_76579_a, attempt, false);
            if (returnable == null) continue;
            cir.setReturnValue((Object)returnable);
            return;
        }
    }

    @Redirect(method={"getRandomizedSpawnPoint"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getTopSolidOrLiquidBlock(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/BlockPos;"))
    private BlockPos fermiummixins_vanillaWorldProvider_getRandomizedSpawnPoint_redirect(World instance, BlockPos blockpos1) {
        return WorldProvider_RespawnProtectionMixin.fermiummixins$getOrAttemptTopSolidBlock(instance, blockpos1, true);
    }

    @Unique
    private static BlockPos fermiummixins$getOrAttemptTopSolidBlock(World world, BlockPos pos, boolean force) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = world.func_175726_f(pos);
        boolean goodPos = false;
        if (!force && ConfigHandler.VANILLA_CONFIG.isRespawnBlacklistedFromBiome(world.func_180494_b(pos))) {
            return null;
        }
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), Math.max(chunk.func_76625_h() + 16, world.func_181545_F() + 1), pos.func_177952_p());
        while (!(blockpos.func_177956_o() <= 8 || (state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76224_d() && state.func_185904_a() != Material.field_151586_h)) {
            if (state.func_185904_a() == Material.field_151586_h || state.func_185904_a().func_76230_c() && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos1) && !state.func_177230_c().isFoliage((IBlockAccess)world, blockpos1)) {
                if (chunk.func_177435_g(blockpos).func_191058_s() || chunk.func_177435_g(blockpos.func_177984_a()).func_191058_s()) break;
                goodPos = true;
                break;
            }
            blockpos = blockpos1;
        }
        return force || goodPos ? blockpos : null;
    }
}

