/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.mixin.vanilla;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={WorldEntitySpawner.class})
public abstract class WorldEntitySpawner_LazyChunksMixin {
    @WrapOperation(method={"findChunksForSpawning"}, at={@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z")})
    private boolean fermiummixins_vanillaWorldEntitySpawner_findChunksForSpawning(Set<ChunkPos> instance, Object obj, Operation<Boolean> original, @Local(argsOnly=true) WorldServer world) {
        ChunkPos cpos = (ChunkPos)obj;
        if (WorldEntitySpawner_LazyChunksMixin.fermiummixins_chunkIsFullyLoadedAtChunkPos(world, cpos.field_77276_a, cpos.field_77275_b)) {
            return (Boolean)original.call(new Object[]{instance, obj});
        }
        return false;
    }

    @ModifyExpressionValue(method={"findChunksForSpawning"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/WorldServer;isAnyPlayerWithinRangeAt(DDDD)Z")})
    private boolean fermiummixins_vanillaWorldEntitySpawner_findChunksForSpawning(boolean playerTooClose, @Local BlockPos.MutableBlockPos spawnPos, @Local ChunkPos selectedChunkPos, @Local(argsOnly=true) WorldServer world) {
        if (playerTooClose) {
            return true;
        }
        int cx = spawnPos.func_177958_n() >> 4;
        int cz = spawnPos.func_177952_p() >> 4;
        if (selectedChunkPos.field_77276_a == cx && selectedChunkPos.field_77275_b == cz) {
            return false;
        }
        return !WorldEntitySpawner_LazyChunksMixin.fermiummixins_chunkIsFullyLoadedAtChunkPos(world, cx, cz);
    }

    @Unique
    private static boolean fermiummixins_chunkIsFullyLoadedAtChunkPos(WorldServer world, int cx, int cz) {
        ChunkProviderServer provider = world.func_72863_F();
        int range = 2;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                if (Math.max(Math.abs(dx), Math.abs(dz)) != range || provider.func_73149_a(cx + dx, cz + dz)) continue;
                return false;
            }
        }
        return true;
    }
}

