/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.mixin.vanilla;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fermiummixins.wrapper.BlockStateIdentityPatchWrapper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.RegistryManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(targets={"net.minecraftforge.registries.GameData$BlockCallbacks"})
public abstract class GameData_IdentityMixin {
    @Unique
    private static final ResourceLocation fermiummixins$BLOCKSTATE_TO_ID = new ResourceLocation("minecraft:blockstatetoid");
    @Unique
    private static final ResourceLocation fermiummixins$BLOCK_TO_ITEM = new ResourceLocation("minecraft:blocktoitemmap");

    @Overwrite(remap=false)
    public void onAdd(IForgeRegistryInternal<Block> owner, RegistryManager stage, int id, Block block, @Nullable Block oldBlock) {
        BiMap blockToItem;
        Item item;
        BlockStateIdentityPatchWrapper.ClearableObjectIntIdentityMapPatched blockstateMap = (BlockStateIdentityPatchWrapper.ClearableObjectIntIdentityMapPatched)((Object)owner.getSlaveMap(fermiummixins$BLOCKSTATE_TO_ID, BlockStateIdentityPatchWrapper.ClearableObjectIntIdentityMapPatched.class));
        if (oldBlock != null) {
            for (IBlockState state : oldBlock.func_176194_O().func_177619_a()) {
                blockstateMap.remove(state);
            }
        }
        if ("minecraft:tripwire".equals(block.getRegistryName().toString())) {
            for (int meta = 0; meta < 15; ++meta) {
                blockstateMap.put(block.func_176203_a(meta), id << 4 | meta);
            }
        }
        boolean[] usedMeta = new boolean[16];
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            int meta = block.func_176201_c(state);
            blockstateMap.put(state, id << 4 | meta);
            usedMeta[meta] = true;
        }
        for (int meta = 0; meta < 16; ++meta) {
            if (block.getClass() == BlockObserver.class || !usedMeta[meta]) continue;
            blockstateMap.put(block.func_176203_a(meta), id << 4 | meta);
        }
        if (oldBlock != null && (item = (Item)(blockToItem = (BiMap)owner.getSlaveMap(fermiummixins$BLOCK_TO_ITEM, BiMap.class)).get((Object)oldBlock)) != null) {
            blockToItem.forcePut((Object)block, (Object)item);
        }
    }

    @Overwrite(remap=false)
    public void onClear(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
        ((BlockStateIdentityPatchWrapper.ClearableObjectIntIdentityMapPatched)((Object)owner.getSlaveMap(fermiummixins$BLOCKSTATE_TO_ID, BlockStateIdentityPatchWrapper.ClearableObjectIntIdentityMapPatched.class))).clear();
    }

    @Overwrite(remap=false)
    public void onCreate(IForgeRegistryInternal<Block> owner, RegistryManager stage) {
        BlockStateIdentityPatchWrapper.ClearableObjectIntIdentityMapPatched idMap = new BlockStateIdentityPatchWrapper.ClearableObjectIntIdentityMapPatched();
        owner.setSlaveMap(fermiummixins$BLOCKSTATE_TO_ID, (Object)idMap);
        owner.setSlaveMap(fermiummixins$BLOCK_TO_ITEM, (Object)HashBiMap.create());
    }
}

