/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.mixin.mobends;

import goblinbob.mobends.core.bender.EntityBenderRegistry;
import goblinbob.mobends.core.bender.PreviewHelper;
import goblinbob.mobends.core.data.EntityData;
import goblinbob.mobends.core.data.EntityDatabase;
import goblinbob.mobends.core.data.IEntityDataFactory;
import goblinbob.mobends.core.data.LivingEntityData;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EntityDatabase.class})
public abstract class EntityDatabase_MemLeakMixin {
    @Unique
    protected final Map<Entity, LivingEntityData<?>> fermiummixins$entryMapNew = new WeakHashMap();

    @Overwrite(remap=false)
    public <T extends LivingEntityData<E>, E extends EntityLivingBase> T get(E entity) {
        return (T)this.fermiummixins$entryMapNew.get(entity);
    }

    @Overwrite(remap=false)
    public <T extends LivingEntityData<E>, E extends EntityLivingBase> T getOrMake(IEntityDataFactory<E> dataCreationFunction, E entity) {
        Object data = this.get(entity);
        if (data == null) {
            data = (LivingEntityData)dataCreationFunction.createEntityData(entity);
            this.add((Entity)entity, (LivingEntityData<?>)data);
        }
        return data;
    }

    @Overwrite(remap=false)
    public void add(Entity entity, LivingEntityData<?> data) {
        this.fermiummixins$entryMapNew.put(entity, data);
    }

    @Overwrite(remap=false)
    public void updateClient() {
        Iterator<Map.Entry<Entity, LivingEntityData<?>>> it = this.fermiummixins$entryMapNew.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Entity, LivingEntityData<?>> entry = it.next();
            LivingEntityData<?> entityData = entry.getValue();
            EntityLivingBase entityInData = entityData.getEntity();
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entry.getKey().func_145782_y());
            if (PreviewHelper.isPreviewEntity((Entity)entityInData) || entity != null && entityInData == entity) {
                entityData.updateClient();
                continue;
            }
            EntityBenderRegistry.instance.clearCache(entityInData);
            it.remove();
        }
    }

    @Overwrite(remap=false)
    public void updateRender(float partialTicks) {
        for (EntityData entityData : this.fermiummixins$entryMapNew.values()) {
            entityData.update(partialTicks);
        }
    }

    @Overwrite(remap=false)
    public void refresh() {
        this.fermiummixins$entryMapNew.clear();
    }

    @Overwrite(remap=false)
    public void onTicksRestart() {
        this.fermiummixins$entryMapNew.values().forEach(EntityData::onTicksRestart);
    }
}

