/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.mixin.corpsecomplex;

import c4.corpsecomplex.common.modules.ExperienceModule;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ExperienceModule.class})
public abstract class ExperienceModule_XPReturnMixin {
    @Shadow(remap=false)
    private static boolean keepXP;
    @Shadow(remap=false)
    private static double xpLoss;
    @Shadow(remap=false)
    private static double xpRecover;
    @Shadow(remap=false)
    private static int maxXPRecover;

    @Shadow(remap=false)
    private static void resetXP(EntityPlayer player) {
    }

    @Shadow(remap=false)
    private static void addExperience(EntityPlayer player, int amount) {
    }

    @Inject(method={"onPlayerRespawnBegin"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void fermiummixins_corpseComplexExperienceModule_onPlayerRespawnBegin(PlayerEvent.Clone e, CallbackInfo ci) {
        if (!keepXP) {
            ci.cancel();
        }
    }

    @Overwrite(remap=false)
    private static void setExperiencesValues(LivingExperienceDropEvent e) {
        EntityPlayer player = (EntityPlayer)e.getEntityLiving();
        if (keepXP) {
            e.setCanceled(true);
        } else {
            int experienceReal = (int)((float)ExperienceModule_XPReturnMixin.fermiummixins$getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
            int dropXP = (int)Math.round((double)experienceReal * xpLoss * xpRecover);
            int keptXP = (int)Math.round((double)experienceReal * (1.0 - xpLoss));
            if (maxXPRecover > 0) {
                dropXP = Math.min(maxXPRecover, dropXP);
            }
            e.setDroppedExperience(dropXP);
            ExperienceModule_XPReturnMixin.resetXP(player);
            ExperienceModule_XPReturnMixin.addExperience(player, keptXP);
        }
    }

    private static int fermiummixins$getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceModule_XPReturnMixin.fermiummixins$sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExperienceModule_XPReturnMixin.fermiummixins$sum(level - 15, 37, 5);
        }
        return 1395 + ExperienceModule_XPReturnMixin.fermiummixins$sum(level - 30, 112, 9);
    }

    private static int fermiummixins$sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }
}

