/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.handlers.forgottenitems;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tschipp.forgottenitems.items.ItemVeinPickaxe;
import tschipp.forgottenitems.util.FIConfig;

public class VeinPickaxeHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        World world = player.field_70170_p;
        ItemStack stack = player.func_184614_ca();
        if (!world.field_72995_K && stack.func_77973_b() instanceof ItemVeinPickaxe && !player.func_184812_l_() && !player.func_70093_af()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            if (!tag.func_74767_n("veinCooldown")) {
                BlockPos pos = event.getPos();
                if (!VeinPickaxeHandler.canMineEffectively(player, pos, stack)) {
                    return;
                }
                tag.func_74757_a("veinCooldown", true);
                stack.func_77982_d(tag);
                IBlockState mat = world.func_180495_p(pos);
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                ArrayList<BlockPos> tempPositions = new ArrayList<BlockPos>();
                positions.add(pos);
                for (int i = 0; i < FIConfig.veinPickaxeRadius; ++i) {
                    for (int j = 0; j < positions.size(); ++j) {
                        VeinPickaxeHandler.addPositions(j, world, positions, tempPositions, mat);
                    }
                    positions.addAll(tempPositions);
                    tempPositions.clear();
                }
                positions.remove(pos);
                int maxDam = stack.func_77958_k();
                for (BlockPos position : positions) {
                    if (stack.func_190926_b() || stack.func_77952_i() > maxDam || !VeinPickaxeHandler.canMineEffectively(player, position, stack)) continue;
                    ((EntityPlayerMP)player).field_71134_c.func_180237_b(position);
                }
                stack.func_77978_p().func_74757_a("veinCooldown", false);
                positions.clear();
                tempPositions.clear();
            }
        }
    }

    private static boolean canMineEffectively(EntityPlayer player, BlockPos pos, ItemStack stack) {
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            return false;
        }
        if (player.field_70170_p.func_175625_s(pos) != null) {
            return false;
        }
        for (String type : stack.func_77973_b().getToolClasses(player.func_184614_ca())) {
            if (!block.isToolEffective(type, state) || block.getHarvestLevel(state) > stack.func_77973_b().getHarvestLevel(player.func_184614_ca(), type, player, state)) continue;
            return true;
        }
        return false;
    }

    private static void addPositions(int i, World world, ArrayList<BlockPos> positions, ArrayList<BlockPos> tempPositions, IBlockState mat) {
        if (world.func_180495_p(positions.get(i).func_177978_c()) == mat && !positions.contains(positions.get(i).func_177978_c()) && !tempPositions.contains(positions.get(i).func_177978_c())) {
            tempPositions.add(positions.get(i).func_177978_c());
        }
        if (world.func_180495_p(positions.get(i).func_177974_f()) == mat && !positions.contains(positions.get(i).func_177974_f()) && !tempPositions.contains(positions.get(i).func_177974_f())) {
            tempPositions.add(positions.get(i).func_177974_f());
        }
        if (world.func_180495_p(positions.get(i).func_177968_d()) == mat && !positions.contains(positions.get(i).func_177968_d()) && !tempPositions.contains(positions.get(i).func_177968_d())) {
            tempPositions.add(positions.get(i).func_177968_d());
        }
        if (world.func_180495_p(positions.get(i).func_177976_e()) == mat && !positions.contains(positions.get(i).func_177976_e()) && !tempPositions.contains(positions.get(i).func_177976_e())) {
            tempPositions.add(positions.get(i).func_177976_e());
        }
        if (world.func_180495_p(positions.get(i).func_177984_a()) == mat && !positions.contains(positions.get(i).func_177984_a()) && !tempPositions.contains(positions.get(i).func_177984_a())) {
            tempPositions.add(positions.get(i).func_177984_a());
        }
        if (world.func_180495_p(positions.get(i).func_177977_b()) == mat && !positions.contains(positions.get(i).func_177977_b()) && !tempPositions.contains(positions.get(i).func_177977_b())) {
            tempPositions.add(positions.get(i).func_177977_b());
        }
    }
}

