/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.handlers.dynamicsurroundings;

import fermiummixins.FermiumMixins;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;

public abstract class CustomEntityChatConfigHandler {
    private static File configFolder = null;
    private static File customEntityChatFile = null;
    private static File customEntityChatTimeFile = null;
    private static final Map<String, String> customEntityChatMap = new HashMap<String, String>();
    private static final Map<String, int[]> customEntityChatTimeMap = new HashMap<String, int[]>();

    @Nullable
    public static Map<String, String> getCustomEntityChatMap(String lang) {
        if (customEntityChatFile == null && !CustomEntityChatConfigHandler.initCustomEntityChatMap(lang)) {
            return null;
        }
        return customEntityChatMap;
    }

    @Nullable
    public static Map<String, int[]> getCustomEntityChatTimeMap() {
        if (customEntityChatTimeFile == null && !CustomEntityChatConfigHandler.initCustomEntityChatTimeMap()) {
            return null;
        }
        return customEntityChatTimeMap;
    }

    private static boolean initCustomEntityChatMap(String lang) {
        if (configFolder == null && !CustomEntityChatConfigHandler.initDirectory()) {
            return false;
        }
        String fileName = "dsurround_chat" + (lang.equals("en_us") || lang.isEmpty() ? "" : "_" + lang) + ".cfg";
        File dSurroundLangChatFile = new File(configFolder, fileName);
        customEntityChatFile = dSurroundLangChatFile.exists() ? dSurroundLangChatFile : new File(configFolder, "dsurround_chat.cfg");
        try {
            if (!customEntityChatFile.exists()) {
                if (!customEntityChatFile.createNewFile()) {
                    FermiumMixins.LOGGER.log(Level.ERROR, "Failed to create new custom entity chat bubble config");
                    return false;
                }
                Files.write(customEntityChatFile.toPath(), "# Format:\n#\n# messageId=weight,text\n#\n# messageId: Must be prefixed with \"chat.\" and terminated with a sequential number (e.g. \".0\")  The\n#            stuff in between is the Entity class name registered in EntityList.  (villager.flee is\n#            a special case).\n#\n# weight:    Relative weight of the entry being selected from the weight table.  The higher the number\n#            the greater chance of selection vs. its peers.\n#\n# text:      The stuff that gets displayed in the client.  Though the server side makes the message\n#            selection language translation does not occur until it get's client side.\n#\nchat.villager.0=10,I like living in Dynamic Surroundings.\nchat.villager.1=15,I used to be a miner until I took a creeper to the face.\nchat.villager.2=20,Don't fear the creepers.  Be terrified!\nchat.villager.3=20,Beet soup for dinner.  Again.\nchat.villager.4=10,Villager TV has a decent program on tonight.  It's called Credits.\nchat.villager.5=10,Only one thing you can do about zombies - run!\nchat.villager.6=15,Why doesn't anyone listen to me?\nchat.villager.7=10,Is this really worth the server ticks?\nchat.villager.8=15,A haircut... A Testificate's dream...\nchat.villager.9=15,Cake isn't a lie!  Well, mostly...\nchat.villager.10=20,Of all the modpacks in the world I had to spawn in this one.\nchat.villager.11=20,I could have had hands, but the designers were lazy.\nchat.villager.12=15,Nothing up my sleeves.  No, really.  I mean that.\nchat.villager.13=15,Never spend your diamonds on a hoe.  I read that somewhere.\nchat.villager.14=15,Did you see Villager Number 9 on TV?\nchat.villager.15=20,...and there was this time I ate a poisoned potato...\nchat.villager.16=10,This isn't my nose, it's a false one.\nchat.villager.17=15,I would have had more in stock but a skeleton shot my supplier.\nchat.villager.18=10,When nature calls you have to go, and fast!\nchat.villager.19=10,I got no respect around here.\nchat.villager.20=15,Of all the foods they could have added why did it have to be beets?\nchat.villager.21=20,Tell Mojang that we, the Testificates, need chairs!\nchat.villager.22=15,It could have been worse.  We could be growing brussel sprouts rather than beets.\nchat.villager.23=10,Gazebo!\nchat.villager.24=15,Klaatu... Verata... Necktie!\nchat.villager.25=10,So much rotten flesh! Not so many ideas...\nchat.villager.26=20,I'm sorry.  It's my implementation.\nchat.villager.27=15,I wish I had a voice like Villager Number 4.\nchat.villager.28=20,Yes, it's true.  I use mental powers to harvest crops.\nchat.villager.29=5,Tell OreCruncher that we need better lines.\nchat.villager.30=10,I found a book titled \"FOOBIE BLETCH\".  I wish I knew what that meant.\nchat.villager.31=5,Hey! Eyes up here!\nchat.villager.32=10,On the plus side we don't have flatulating cows.\nchat.villager.33=15,Let's play the quiet game.\nchat.villager.34=15,Who is this Squidward everyone keeps talking about?\nchat.villager.35=20,The union said we had to trade flint for gravel and an emerald.\nchat.villager.36=15,This is, like, the opposite of what I wanted to do today.\nchat.villager.37=15,My torture continues.\nchat.villager.38=15,If it weren't for bad luck I'd have no luck at all.\nchat.villager.39=10,Oh, I'm sorry.  I forgot I only exist when you need something.\nchat.villager.40=15,A day without sunshine is like night.\nchat.villager.41=20,Drawing on my fine command of language, I said nothing.\nchat.villager.42=15,I used to be indecisive. Now I'm not sure.\nchat.villager.43=10,Silence is golden, unless you have kids, then silence is just plain suspicious.\nchat.villager.44=15,Actually, the Nether Star is the Wither's Calcified Ball of Hatred.\nchat.villager.45=5,...and then I found out I could go blind so I stopped.\nchat.villager.46=15,I lost my copy of Better Blocks and Mines.  You wouldn't happen to have a copy?\nchat.villager.47=10,If you have nether warts I can sell you a potion to cure it.\nchat.villager.48=20,You tell the best stories.\nchat.villager.49=15,I was fired because I forgot to put a cover sheet on a TPS report.\nchat.villager.50=10,I always wanted to be somebody, but now I realize I should have been more specific.\nchat.villager.51=15,I never said most of the things I said.\nchat.villager.52=15,Impressive.\nchat.villager.53=15,Any problem can be solved with the suitable application of redstone and pumpkin pie.\nchat.villager.54=10,\"First... cut my son's buns!\"  That was a funny.\nchat.villager.55=10,Yeah.\nchat.villager.56=15,...and I drank this stuff called Fel Slider Cider.  It was a mistake...\nchat.villager.57=10,The axe forgets; the tree remembers.\nchat.villager.58=15,Never dig straight down.\nchat.villager.59=10,Don't Panic.\nchat.villager.60=5,More cow bell!\nchat.villager.61=15,Well that happened.\nchat.villager.62=15,This is perplexing.\nchat.villager.63=15,Yay!  A friend!\nchat.villager.64=10,I'm saying this now so I can have a flashback later.\nchat.villager.65=5,Of course he'd do it.  He had plot armor!\n\nchat.villager.flee.0=20,Run away! Run away!\nchat.villager.flee.1=20,!!! HELP !!!\nchat.villager.flee.2=5,I want my Parental Unit!\nchat.villager.flee.3=15,Testificate Man! We need you!\nchat.villager.flee.4=10,I'm going to need a clothing change!\nchat.villager.flee.5=15,Feet don't fail me now!\nchat.villager.flee.6=10,I wish I was programmed to fight!\nchat.villager.flee.7=15,Too bad I failed that online defense course!\nchat.villager.flee.8=5,If only I had a wheelbarrow and a holocaust cloak!\nchat.villager.flee.9=15,I have no brain! Why are you chasing me?!?\nchat.villager.flee.10=5,Seems like the Benny Hill theme song would be appropriate about now.\nchat.villager.flee.11=10,He's got an arm off!\nchat.villager.flee.12=15,It's every villager for themselves!\nchat.villager.flee.13=10,Wow, these fellas really let themselves go.\nchat.villager.flee.14=15,It seems I was doing this very thing yesterday.\nchat.villager.flee.15=5,And that's our cue to ski-doo!\nchat.villager.flee.16=10,Exit! Stage left!\nchat.villager.flee.17=10,You figure this village would have had walls by now.\nchat.villager.flee.18=10,Somebody set up us the bomb!\nchat.villager.flee.19=10,Shop smart! Shop S-Mart!\n\nchat.zombie.0=25,BBBBBRRRRRAAAAAIIIIIINNNNNNSSSS!\nchat.zombie.1=20,Grrrrrr\nchat.zombie.2=10,I need a better gig.\nchat.zombie.3=5,In short, in matters vegetable, animal, and mineral, I am the very model of a modern Major-General.\nchat.zombie.4=10,Anyone have a throat lozenge?\nchat.zombie.5=10,** Sigh **\nchat.zombie.6=5,Stay away from the light!\nchat.zombie.7=10,Can't resist! Must...chase...villager!\nchat.zombie.8=15,My arms are getting tired.\nchat.zombie.9=10,Oh no!  Not again!\nchat.zombie.10=5,All your base are belong to us\nchat.zombie.11=10,Come get some!\nchat.zombie.12=10,Groovy!\nchat.zombie.13=10,Hey kids you remember i'm a professional, don't try this at home!\nchat.zombie.14=10,So many villagers, so little time.\nchat.zombie.15=10,Everything's better with zombies!\nchat.zombie.16=10,Now that I've introduced my self I should like to know what's going on here?\n\nchat.skeleton.0=10,The short fortune teller who escaped from prison was a small medium at large.\nchat.skeleton.1=10,I don't know where I keep my arrows.  It's a mystery, like villagers having no hands.\nchat.skeleton.2=15,It's not like I had a choice or anything.\nchat.skeleton.3=5,What? You expected intelligent conversation?\nchat.skeleton.4=15,I just got lost in thought. It was unfamiliar territory.\nchat.skeleton.5=15,If everything seems to be going well, you have obviously overlooked something.\nchat.skeleton.6=15,I was trying to daydream, but my mind kept wandering.\nchat.skeleton.7=10,Whoever said nothing was impossible obviously never tried slamming a revolving door.\nchat.skeleton.8=10,Knowledge is realizing that the street is one-way, wisdom is looking both directions anyway.\nchat.skeleton.9=10,You keep using that word.  I don't think it means what you think it means.\nchat.skeleton.10=10,Chicken!  Fight like a skeleton!\nchat.skeleton.11=10,Oh,look. There's some lovely filth over here.\nchat.skeleton.12=5,If you cannot get rid of the family skeleton, you may as well make it dance.\nchat.skeleton.13=5,There is something about a closet that makes a skeleton terribly restless.\nchat.skeleton.14=5,I can be a super model!\nchat.skeleton.15=10,A bazooka is the skeleton key of the impatient.\nchat.skeleton.16=10,Tact is for people who aren't witty enough to use sarcasm.\nchat.skeleton.17=10,On the other hand, you have different fingers.\nchat.skeleton.18=10,There is a strong need for a sarcasm font.\nchat.skeleton.19=10,I am an acquired taste.\n\nchat.witch.0=10,Yes, I can drive a stick.\nchat.witch.1=15,By the pricking of my thumbs, something wicked this way comes.\nchat.witch.2=10,Do not judge my path, you haven't walked in my shoes...or ridden my broom.\nchat.witch.3=15,All trespassers will be used as ingredients in the brew!\nchat.witch.4=10,Fair is foul, and foul is fair.\nchat.witch.5=10,Going so soon? I wouldn't hear of it. Why my little party's just beginning.\nchat.witch.6=15,Why do I have to look like a normal villager?\nchat.witch.7=15,I think I will keep it under my hat for now.\nchat.witch.8=10,I will get you and your little dog, too!  You have a dog, right?\nchat.witch.9=10,Don't ask me where I keep all these potions.  Where do you keep all that dirt?\nchat.witch.10=10,I wish I had a flying monkey.\nchat.witch.11=15,Have you ever had a rock as a familiar?  It was the rage back in the day.\nchat.witch.12=15,It's not a wart! It's a beauty mark!\nchat.witch.13=10,Some days I think my nose has a life of it's own.\nchat.witch.14=15,My work is never done...\nchat.witch.15=10,Tis now the very witching time of night, when churchyards yawn and hell itself breathes out contagion to this world.\nchat.witch.16=10,Double, double toil and trouble; fire burn and cauldron bubble.\n\n# Special token for using splash screen sayings - don't translate!\nchat.squid.0=20,$MINECRAFT$\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            try (Stream<String> stream = Files.lines(customEntityChatFile.toPath());){
                List list = stream.map(String::trim).filter(s -> !s.isEmpty()).filter(s -> !s.startsWith("//") && !s.startsWith("#")).filter(s -> s.contains("=")).collect(Collectors.toList());
                for (String entry : list) {
                    String[] entryArray = (String[])Arrays.stream(entry.split("=", 2)).map(String::trim).toArray(String[]::new);
                    customEntityChatMap.put(entryArray[0], entryArray[1]);
                }
            }
            return true;
        }
        catch (Exception ex) {
            FermiumMixins.LOGGER.log(Level.ERROR, "Failed to initialize custom entity chat bubble config: " + ex);
            return false;
        }
    }

    private static boolean initCustomEntityChatTimeMap() {
        if (configFolder == null && !CustomEntityChatConfigHandler.initDirectory()) {
            return false;
        }
        customEntityChatTimeFile = new File(configFolder, "dsurround_chat_time.cfg");
        try {
            if (!customEntityChatTimeFile.exists()) {
                if (!customEntityChatTimeFile.createNewFile()) {
                    FermiumMixins.LOGGER.log(Level.ERROR, "Failed to create new custom entity chat bubble time config");
                    return false;
                }
                Files.write(customEntityChatTimeFile.toPath(), "# Format:\n#\n# name,baseTick,randomTick\n#\n# name:        The Entity class name registered in EntityList. (Ex. villager/skeleton/etc.)\n#\n# baseTick:    Minimum amount of ticks before playing a chat message for the entity.\n#\n# randomTick:  Range for the random amount of ticks to be added to the baseTick.\n#              Ticks until next message = baseTick + (Random number between 0 and randomTick)\n#\n# Default values are 400,1200 for all entities except Squids, which are 600,1200\n#\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            try (Stream<String> stream = Files.lines(customEntityChatTimeFile.toPath());){
                List list = stream.map(String::trim).filter(s -> !s.isEmpty()).filter(s -> !s.startsWith("//") && !s.startsWith("#")).filter(s -> s.contains(",")).collect(Collectors.toList());
                for (String entry : list) {
                    String[] entryArray = (String[])Arrays.stream(entry.split(",", 3)).map(String::trim).toArray(String[]::new);
                    customEntityChatTimeMap.put(entryArray[0], new int[]{Integer.parseInt(entryArray[1]), Integer.parseInt(entryArray[2])});
                }
            }
            return true;
        }
        catch (Exception ex) {
            FermiumMixins.LOGGER.log(Level.ERROR, "Failed to initialize custom entity chat bubble time config: " + ex);
            return false;
        }
    }

    private static boolean initDirectory() {
        configFolder = new File("config", "fermiummixins");
        if (!(configFolder.exists() && configFolder.isDirectory() || configFolder.mkdir())) {
            FermiumMixins.LOGGER.log(Level.ERROR, "Could not create the folder for custom entity chat bubble config");
            return false;
        }
        return true;
    }
}

