/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.handlers.bountifulbaubles;

import baubles.api.BaublesApi;
import cursedflames.bountifulbaubles.item.ModItems;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.event.FirstAidLivingDamageEvent;
import ichttt.mods.firstaid.common.network.MessageUpdatePart;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BrokenHeartBaubleHandler {
    private static final UUID BROKENHEART_HEALTH_UUID = UUID.fromString("554f3929-4193-4ae5-a4da-4b528a89ca32");

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onFirstAidLivingDamageLow(FirstAidLivingDamageEvent event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getUndistributedDamage() > 1000.0f) {
            return;
        }
        if (BaublesApi.isBaubleEquipped((EntityPlayer)event.getEntityPlayer(), (Item)ModItems.trinketBrokenHeart) == -1) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        boolean failed = false;
        ArrayList<AbstractDamageablePart> parts = new ArrayList<AbstractDamageablePart>();
        for (AbstractDamageablePart part : event.getAfterDamage()) {
            if (!part.canCauseDeath || !(part.currentHealth <= 0.0f)) continue;
            if (part.getMaxHealth() >= 4) {
                parts.add(part);
                continue;
            }
            failed = true;
        }
        if (!failed && !parts.isEmpty()) {
            IAttributeInstance maxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            AttributeModifier modifier = maxHealth.func_111127_a(BROKENHEART_HEALTH_UUID);
            double prevMaxHealthDamage = 0.0;
            if (modifier != null) {
                prevMaxHealthDamage = modifier.func_111164_d();
            }
            double curMaxHealth = maxHealth.func_111125_b();
            for (AttributeModifier mod : maxHealth.func_111130_a(0)) {
                curMaxHealth += mod.func_111164_d();
            }
            double originalMaxHealth = curMaxHealth - prevMaxHealthDamage;
            double healthToRemove = originalMaxHealth * 0.3 + (double)(parts.size() * 2) + (double)event.getUndistributedDamage();
            if (healthToRemove > curMaxHealth - 2.0) {
                return;
            }
            for (AbstractDamageablePart part : parts) {
                part.heal(1.0f, null, false);
                if (!(event.getEntityPlayer() instanceof EntityPlayerMP)) continue;
                FirstAid.NETWORKING.sendTo((IMessage)new MessageUpdatePart(part), (EntityPlayerMP)event.getEntityPlayer());
            }
            if (modifier != null) {
                maxHealth.func_111124_b(modifier);
            }
            modifier = new AttributeModifier(BROKENHEART_HEALTH_UUID, "Broken Heart MaxHP drain", prevMaxHealthDamage - healthToRemove, 0);
            maxHealth.func_111121_a(modifier);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187602_cF, SoundCategory.PLAYERS, 1.2f, (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 0.8f);
        }
    }
}

