/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.config;

import com.google.common.collect.BiMap;
import fermiumbooter.annotations.MixinConfig;
import fermiummixins.FermiumMixins;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@MixinConfig(name="fermiummixins")
public class VanillaConfig {
    @Config.Comment(value={"Patches MC-119971, created by EigenCraft Unofficial Patch"})
    @Config.Name(value="MC-119971 Outdated Chunk Data Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.outdatedchunkdata.json", defaultValue=false)
    public boolean outdatedChunkData = false;
    @Config.Comment(value={"Makes water reduce fall distance per tick instead of forcing distance to 0"})
    @Config.Name(value="Configurable Water Fall Damage Reduction (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.configwaterfalldamage.json", defaultValue=false)
    public boolean configurableWaterFallDamageReduction = false;
    @Config.Comment(value={"How many blocks to reduce fall distance by per tick when falling in water\nRequires \"Configurable Water Fall Damage Reduction (Vanilla)\" enabled"})
    @Config.Name(value="Fall Distance Reduction in Water")
    @Config.RangeDouble(min=1.0, max=100.0)
    public double waterFallDamageReduction = 4.0;
    @Config.Comment(value={"Lowers the player's eye height while crouching to be more like modern minecraft versions"})
    @Config.Name(value="Lowered Crouch Eye Height (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.lowercroucheyeheight.json", defaultValue=false)
    public boolean lowerCrouchEyeHeight = false;
    @Config.Comment(value={"Patches issues with player health attributes being lowered between packets causing desynced death"})
    @Config.Name(value="Health Desync Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.healthdesyncpatch.json", defaultValue=false)
    public boolean healthDesyncPatch = false;
    @Config.Comment(value={"Smoothed eye height when crouching, created by RandomPatches\nIncompatible: RandomPatches\nIncompatible: AquaAcrobatics"})
    @Config.Name(value="Smooth Crouching (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.smoothcrouching.json", defaultValue=false)
    @MixinConfig.CompatHandlingContainer(value={@MixinConfig.CompatHandling(modid="randompatches", desired=false, reason="Mod contains option for identical feature, ensure only one is enabled"), @MixinConfig.CompatHandling(modid="aquaacrobatics", desired=false, reason="Mod contains identical feature, will conflict if this is enabled")})
    public boolean smoothCrouching = false;
    @Config.Comment(value={"Force Mending to prioritize damaged items first, instead of randomly picking"})
    @Config.Name(value="Mending Priorities (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.mendingpriorities.json", defaultValue=false)
    public boolean mendingPriorities = false;
    @Config.Comment(value={"Patches MC-92916, created by EigenCraft Unofficial Patch"})
    @Config.Name(value="MC-92916 Entity Tracker Desync Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.entitytrackerdesync.json", defaultValue=false)
    public boolean entityTrackerDesyncPatch = false;
    @Config.Comment(value={"Fixes certain particles sent to the client from serverside never actually rendering, created by RandomPatches\nIncompatible: RandomPatches"})
    @Config.Name(value="Particle Render Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.particlerenderpatch.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="randompatches", desired=false, reason="Mod contains option for identical feature, ensure only one is enabled")
    public boolean particleRenderPatch = false;
    @Config.Comment(value={"Patches MC-108469, created by EigenCraft Unofficial Patch"})
    @Config.Name(value="MC-108469 Chunk Entity List Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.chunkentitylistpatch.json", defaultValue=false)
    public boolean chunkEntityListPatch = false;
    @Config.Comment(value={"Overrides getCanSpawn for Giant Zombies, allowing them to spawn from spawners"})
    @Config.Name(value="Giant Zombie Spawn Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.giantzombiespawnfix.json", defaultValue=false)
    public boolean giantZombieSpawnFix = false;
    @Config.Comment(value={"Prevents nether portals from spawning zombie pigmen"})
    @Config.Name(value="Stop Pigmen Portal Spawns (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.stoppigmenportalspawns.json", defaultValue=false)
    public boolean stopPigmenPortalSpawns = false;
    @Config.Comment(value={"Adds a blacklist to prevent certain potion effects from working on tipped arrows"})
    @Config.Name(value="Allow Tipped Arrow Blacklist (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.tippedarrowblacklist.json", defaultValue=false)
    public boolean allowTippedArrowBlacklist = false;
    @Config.Comment(value={"Potion Blacklist for Tipped Arrows\nRequires \"Tipped Arrow Blacklist (Vanilla)\" enabled"})
    @Config.Name(value="Tipped Arrow Blacklist")
    public String[] tippedArrowBlacklist = new String[]{""};
    @Config.Comment(value={"Skips checking over-sized AABB for collisions when teleporting long distances which can cause extreme lag"})
    @Config.Name(value="Teleporting Lag Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.teleportinglagpatch.json", defaultValue=false)
    public boolean teleportingLagPatch = false;
    @Config.Comment(value={"Removes the sky light requirement check from Strays and Husks when spawning"})
    @Config.Name(value="Stray/Husk Spawning Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.strayhuskspawningfix.json", defaultValue=false)
    public boolean strayHuskSpawningFix = false;
    @Config.Comment(value={"Makes Guardians not sink while idle in water"})
    @Config.Name(value="Prevent Idle Guardian Sinking (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.idleguardiansinking.json", defaultValue=false)
    public boolean preventIdleGuardianSinking = false;
    @Config.Comment(value={"Makes potion effects actually display their values above amplifier 3 in the inventory screen"})
    @Config.Name(value="Potion Amplifier Visibility (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.potionamplifiervisibility.json", defaultValue=false)
    public boolean potionAmplifierVisibility = false;
    @Config.Comment(value={"Patches MC-63340 stops sleep resetting weather and weather timers which causes weather to be less common"})
    @Config.Name(value="MC-63340 Stop Sleep Resetting Weather (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.stopsleepresettingweather.json", defaultValue=false)
    public boolean stopSleepResettingWeather = false;
    @Config.Comment(value={"Makes sleeping still reset the weather only if it is actively raining/thundering\nRequires \"MC-63340 Stop Sleep Resetting Weather (Vanilla)\" enabled"})
    @Config.Name(value="Fix Weather Reset on Sleep Conditionally")
    public boolean stopSleepResettingWeatherConditionally = true;
    @Config.Comment(value={"Caches System.currentTimeMillis per tick for use by WorldBorder::getDiameter for performance"})
    @Config.Name(value="World Border Time Cache (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.worldbordertimecache.json", defaultValue=false)
    public boolean worldBorderTimeCache = false;
    @Config.Comment(value={"Disables water ticking from forced updates on chunk generation for performance"})
    @Config.Name(value="Water Chunk Gen Ticking Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.waterchunkgenticking.json", defaultValue=false)
    public boolean waterChunkGenTicking = false;
    @Config.Comment(value={"Enables retrying random spawn placement to get a better location (Avoids spawning in blocks or liquid)"})
    @Config.Name(value="Random Respawn Placement Protection (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.respawnprotection.json", defaultValue=false)
    public boolean randomRespawnPlacementProtection = false;
    @Config.Comment(value={"How many attempts will randomly respawning try to find a good spawn point\nRequires \"Random Respawn Placement Protection (Vanilla)\" enabled"})
    @Config.Name(value="Respawn Protection Attempts")
    @Config.RangeInt(min=0, max=4)
    public int respawnProtectionAttempts = 1;
    @Config.Comment(value={"Biome name blacklist to attempt to avoid respawning in\nRequires \"Random Respawn Placement Protection (Vanilla)\" enabled"})
    @Config.Name(value="Respawn Protection Biome Name Blacklist")
    public String[] respawnProtectionBiomeBlacklist = new String[0];
    @Config.Comment(value={"Biome type blacklist to attempt to avoid respawning in\nRequires \"Random Respawn Placement Protection (Vanilla)\" enabled"})
    @Config.Name(value="Respawn Protection Biome Type Blacklist")
    public String[] respawnProtectionBiomeTypeBlacklist = new String[]{"OCEAN"};
    @Config.Comment(value={"Allows for setting minimum and maximum Gamma values"})
    @Config.Name(value="Allow Clamping Gamma (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.clampgamma.json", defaultValue=false)
    public boolean allowClampingGamma = false;
    @Config.Comment(value={"Minimum Gamma value for brightness\nRequires \"Allow Clamping Gamma (Vanilla)\" enabled"})
    @Config.Name(value="Minimum Gamma Value")
    public float minimumGammaValue = 0.0f;
    @Config.Comment(value={"Maximum Gamma value for brightness\nRequires \"Allow Clamping Gamma (Vanilla)\" enabled"})
    @Config.Name(value="Maximum Gamma Value")
    public float maximumGammaValue = 1.0f;
    @Config.Comment(value={"Nukes the Advancement system from loading, save a large amount of memory and performance"})
    @Config.Name(value="Nuke Advancements (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.nukeadvancements.json", defaultValue=false)
    public boolean nukeAdvancements = false;
    @Config.Comment(value={"Allows for modifying the radius of spawn chunks to keep loaded when a player is online"})
    @Config.Name(value="Spawn Chunk Radius Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.spawnchunkradiuspatch.json", defaultValue=false)
    public boolean spawnChunkRadiusPatch = false;
    @Config.Comment(value={"Radius of spawn chunks to keep loaded (-1 to load none)\nRequires \"Spawn Chunk Radius Patch (Vanilla)\" enabled"})
    @Config.Name(value="Spawn Chunk Radius")
    @Config.RangeInt(min=-1, max=8)
    public int spawnChunkRadius = -1;
    @Config.Comment(value={"Cache the player's chunk position to not refresh the visible chunk list every tick to save on memory allocation"})
    @Config.Name(value="Chunk Visibility Cache (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.chunkvisibilitycache.json", defaultValue=false)
    public boolean chunkVisibilityCache = false;
    @Config.Comment(value={"Sets world flammable checks to use an existing mutable blockpos instead of creating a new one during flammable checks to save on memory allocation"})
    @Config.Name(value="World Flammable BlockPos Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.worldflammablepos.json", defaultValue=false)
    public boolean worldFlammableBlockposPatch = false;
    @Config.Comment(value={"Sets particles by default to not do collision checks to save performance, unless defined otherwise"})
    @Config.Name(value="Particle Collision Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.particlecollisionfix.json", defaultValue=false)
    public boolean particleCollisionFix = false;
    @Config.Comment(value={"List of particle classes to keep collision enabled for\nRequires \"Particle Collision Fix (Vanilla)\" enabled"})
    @Config.Name(value="Particle Retain Collision List")
    public String[] particleRetainCollisionList = new String[]{""};
    @Config.Comment(value={"Fixes arrows stuck in the ground rendering particles like tipped arrows when a world is reloaded"})
    @Config.Name(value="Untipped Arrow Particles Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.untippedarrowparticles.json", defaultValue=false)
    public boolean untippedArrowParticlesFix = false;
    @Config.Comment(value={"Fixes the player's model shaking when in the death screen"})
    @Config.Name(value="Player Death Shake Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.playerdeathshakefix.json", defaultValue=false)
    public boolean playerDeathShakeFix = false;
    @Config.Comment(value={"Allows for hoes to be repaired using their repair material like normal tools"})
    @Config.Name(value="Allow Hoe Repairing (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.hoerepair.json", defaultValue=false)
    public boolean allowHoeRepairing = false;
    @Config.Comment(value={"Allows for setting timings of weather events with config values"})
    @Config.Name(value="Weather Timing Config (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.weathertiming.json", defaultValue=false)
    public boolean weatherTiming = false;
    @Config.Comment(value={"Sets the range of how many ticks thunder will last, added to minimum\nRequires \"Weather Timing Config (Vanilla)\" enabled"})
    @Config.Name(value="Thunder Duration Range Ticks")
    @Config.RangeInt(min=1200)
    public int thunderActiveRange = 12000;
    @Config.Comment(value={"Sets the minimum amount of ticks thunder will last\nRequires \"Weather Timing Config (Vanilla)\" enabled"})
    @Config.Name(value="Thunder Duration Minimum Ticks")
    @Config.RangeInt(min=1200)
    public int thunderActiveMinimum = 3600;
    @Config.Comment(value={"Sets the range of how many ticks it will take for thunder to start, added to minimum\nRequires \"Weather Timing Config (Vanilla)\" enabled"})
    @Config.Name(value="Thunder Time Until Start Range Ticks")
    @Config.RangeInt(min=1200)
    public int thunderInactiveRange = 168000;
    @Config.Comment(value={"Sets the minimum amount of ticks it will take for thunder to start\nRequires \"Weather Timing Config (Vanilla)\" enabled"})
    @Config.Name(value="Thunder Time Until Start Minimum Ticks")
    @Config.RangeInt(min=1200)
    public int thunderInactiveMinimum = 12000;
    @Config.Comment(value={"Sets the range of how many ticks rain will last, added to minimum\nRequires \"Weather Timing Config (Vanilla)\" enabled"})
    @Config.Name(value="Rain Duration Range Ticks")
    @Config.RangeInt(min=1200)
    public int rainActiveRange = 12000;
    @Config.Comment(value={"Sets the minimum amount of ticks rain will last\nRequires \"Weather Timing Config (Vanilla)\" enabled"})
    @Config.Name(value="Rain Duration Minimum Ticks")
    @Config.RangeInt(min=1200)
    public int rainActiveMinimum = 12000;
    @Config.Comment(value={"Sets the range of how many ticks it will take for rain to start, added to minimum\nRequires \"Weather Timing Config (Vanilla)\" enabled"})
    @Config.Name(value="Rain Time Until Start Range Ticks")
    @Config.RangeInt(min=1200)
    public int rainInactiveRange = 168000;
    @Config.Comment(value={"Sets the minimum amount of ticks it will take for rain to start\nRequires \"Weather Timing Config (Vanilla)\" enabled"})
    @Config.Name(value="Rain Time Until Start Minimum Ticks")
    @Config.RangeInt(min=1200)
    public int rainInactiveMinimum = 12000;
    @Config.Comment(value={"Fixes a vanilla/forge bug limiting the xp result of smelting to 1 - 2 xp per item"})
    @Config.Name(value="Furnace XP Limit Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.furnacexplimitfix.json", defaultValue=false)
    public boolean furnaceXPLimitFix = false;
    @Config.Comment(value={"Suppress addpacket for removed entity log warnings"})
    @Config.Name(value="Suppress AddPacket For Removed Entity Warnings (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.suppressaddpacket.json", defaultValue=false)
    public boolean suppressAddPacketWarnings = false;
    @Config.Comment(value={"Suppress received passengers for unknown entity log warnings"})
    @Config.Name(value="Suppress Received Passengers For Unknown Entity Warnings (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.suppressreceivedpassengers.json", defaultValue=false)
    public boolean suppressReceivedPassengersWarnings = false;
    @Config.Comment(value={"Fixes dying then leaving a hardcore world without spectating first not properly unloading the world"})
    @Config.Name(value="Hardcore Game Over Unloading Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.hardcoregameoverfix.json", defaultValue=false)
    public boolean hardcoreGameOverFix = false;
    @Config.Comment(value={"Attempts to fix errors from processing packets received after the player has already left a world or server"})
    @Config.Name(value="Fix Delayed Packet Errors (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.delayedpacketerrors.json", defaultValue=false)
    public boolean fixDelayedPacketErrors = false;
    @Config.Comment(value={"At low render distances (<9) mobs can spawn in lazy loaded chunks, filling the mob cap without being able to despawn"})
    @Config.Name(value="Prevent Mob Spawns in Lazy Chunks (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.lazychunkmobspawns.json", defaultValue=false)
    public boolean preventMobSpawnsInLazyChunks = false;
    @Config.Comment(value={"Allows for setting the maximum range (height) of bedrock generation"})
    @Config.Name(value="Maximum Bedrock Generation Range Config (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.maxbedrockrange.json", defaultValue=false)
    public boolean maximumBedrockGenerationRangeConfig = false;
    @Config.Comment(value={"Upper limit for bedrock to attempt to generate\nRequires \"Maximum Bedrock Generation Range Config (Vanilla)\" enabled"})
    @Config.Name(value="Maximum Bedrock Generation Range")
    @Config.RangeInt(min=1)
    public int maximumBedrockGenerationRange = 5;
    @Config.Comment(value={"Allows for replacing the world generation filler block by dimension id (Warning: this will occur a slight performance cost, and may cause issues with world generation that expects blocks to be stone)"})
    @Config.Name(value="Custom Dimension Filler Block (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.customdimensionfillerblock.json", defaultValue=false)
    public boolean customDimensionFillerBlock = false;
    @Config.Comment(value={"List of dimension ids and the block (Format: id,blockid) to override as the default filler block\nRequires \"Custom Dimension Filler Block (Vanilla)\" enabled"})
    @Config.Name(value="Custom Dimension Filler Block Override List")
    public String[] customDimensionFillerBlockList = new String[0];
    @Config.Comment(value={"Allows for setting additional blocks to allow to be carved by caves and ravines"})
    @Config.Name(value="Additional Caves and Ravines Carver Blocks (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.additionalcarverblocks.json", defaultValue=false)
    public boolean additionalCarverBlocks = false;
    @Config.Comment(value={"List of blocks to additionally allow caves and ravines to carve\nRequires \"Additional Caves and Ravines Carver Blocks (Vanilla)\" enabled"})
    @Config.Name(value="Cave and Ravine Carver Block List")
    public String[] additionalCarverBlocksList = new String[0];
    @Config.Comment(value={"Merge XP orbs together up to a customizable maximum XP value\nIncompatible: Clumps"})
    @Config.Name(value="Merge XP Orbs (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.mergexporbs.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="clumps", desired=false, reason="Replaces mod function")
    public boolean mergeXPOrbs = false;
    @Config.Comment(value={"XP orbs will only keep merging until they have this amount of XP stored in them\nRequires \"Merge XP Orbs (Vanilla)\" enabled"})
    @Config.Name(value="XP Orb Max Merged Value")
    public int xpOrbMaxMergedValue = 100;
    @Config.Comment(value={"XP orbs will only start merging if they have existed for at least this many ticks\nRequires \"Merge XP Orbs (Vanilla)\" enabled"})
    @Config.Name(value="XP Orb Earliest Merge Tick")
    public int xpOrbEarliestMergeTick = 100;
    @Config.Comment(value={"Some mods apply potion effects clientside which leads to desyncs, enable to forcibly prevent those"})
    @Config.Name(value="Cancel Incorrect Clientside addPotionEffect Calls (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.cancelclientpotions.json", defaultValue=false)
    public boolean cancelClientPotions = false;
    @Config.Comment(value={"Fixes soups not returning bowls correctly when allowed to stack"})
    @Config.Name(value="Stackable Soup Return Bowls Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.stackablesoupbowlfix.json", defaultValue=false)
    public boolean stackableSoupBowlFix = false;
    @Config.Comment(value={"Suppresses potentially dangerous prefix errors"})
    @Config.Name(value="Suppress Dangerous Prefix Errors (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.suppressdangerousprefix.json", defaultValue=false)
    public boolean suppressDangerousPrefixErrors = false;
    @Config.Comment(value={"Suppresses broken ore dictionary errors"})
    @Config.Name(value="Suppress Broken Ore Dictionary Errors (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.suppressbrokenoredict.json", defaultValue=false)
    public boolean suppressBrokenOreDict = false;
    @Config.Comment(value={"Allows for blacklisting biomes to prevent spawning of Mineshafts"})
    @Config.Name(value="Mineshaft Biome Blacklist Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.mineshaftbiomeblacklist.json", defaultValue=false)
    public boolean mineshaftBiomeBlacklistPatch = false;
    @Config.Comment(value={"Biome name blacklist to prevent Mineshafts from spawning\nRequires \"Mineshaft Biome Blacklist Patch (Vanilla)\" enabled"})
    @Config.Name(value="Mineshaft Biome Name Blacklist")
    public String[] mineshaftBiomeNameBlacklist = new String[]{""};
    @Config.Comment(value={"Biome type blacklist to prevent Mineshafts from spawning\nRequires \"Mineshaft Biome Blacklist Patch (Vanilla)\" enabled"})
    @Config.Name(value="Mineshaft Biome Type Blacklist")
    public String[] mineshaftBiomeTypeBlacklist = new String[]{""};
    @Config.Comment(value={"Allows for overriding entity view distances with alternate values"})
    @Config.Name(value="Allow Entity View Distance Override (Vanilla)")
    public boolean allowEntityViewDistanceOverride = false;
    @Config.Comment(value={"List of modded entities and the value of their view distance to override with\nFormat: entityid=distance\nRequires \"Allow Entity View Distance Override (Vanilla)\" enabled"})
    @Config.Name(value="Entity View Distance Override List")
    public Map<String, Integer> entityViewDistanceOverrideList = new HashMap<String, Integer>(){
        {
            this.put("battletowers:golem", 64);
        }
    };
    @Config.Comment(value={"Makes lightning not destroy items"})
    @Config.Name(value="Stop Lightning Destroying Items")
    @Config.RequiresMcRestart
    public boolean stopLightningDestroyingItems = false;
    @Config.Comment(value={"Disallows boss mobs from entering minecarts and boats\nAdditionally disallows Infernal/Blight/Champion mobs if InfernalMobs/ScalingHealth/Champions is loaded"})
    @Config.Name(value="Boss Vehicle Prevention (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.bossvehicle.json", defaultValue=false)
    public boolean bossVehiclePrevention = false;
    @Config.Comment(value={"Disallows all hostile mobs (IMob) from entering minecarts and boats\nRequires \"Boss Vehicle Prevention (Vanilla)\" enabled"})
    @Config.Name(value="All Mob Vehicle Prevention")
    public boolean allMobVehiclePrevention = false;
    @Config.Comment(value={"Attempts to return items to the player's inventory on closing beacon/merchant guis instead of dropping them on the ground"})
    @Config.Name(value="Beacon/Merchant GUI Item Drop Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.containerdropfix.json", defaultValue=false)
    public boolean beaconMerchantGuiItemDropFix = false;
    @Config.Comment(value={"Improves performance by preventing pathfinding from forcing chunk loading"})
    @Config.Name(value="Prevent Pathfinding Chunk Loading (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.pathfindingloading.json", defaultValue=false)
    public boolean preventPathfindingChunkLoading = false;
    @Config.Comment(value={"Replaces some getMaterial checks during chunk and biome generation with direct reference checks, slightly improving performance"})
    @Config.Name(value="World Gen Material Check Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.materialcheck.json", defaultValue=false)
    public boolean worldGenMaterialCheckFix = false;
    @Config.Comment(value={"Improves tick performance of falling block checks"})
    @Config.Name(value="Falling Block Tick Performance (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.fallblocktick.json", defaultValue=false)
    public boolean fallingBlockTickPerformance = false;
    @Config.Comment(value={"Suppresses checking and logging of OpenGL errors for performance\nWarning: Do not report render errors to anyone while this option is enabled, disable this first in order to get a correct error log"})
    @Config.Name(value="Suppress OpenGL Error Checking (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.glerror.json", defaultValue=false)
    public boolean suppressOpenGLErrorChecks = false;
    @Config.Comment(value={"Rewrites part of Forge/Vanilla IBlockState registry handling to fix slow identity-hash-based checks\nThis can improve performance of chunk saving and chunk generation\nWarning: Do not add this to an existing world/pack without making a backup and testing, any mod modifying blockstate instancing/blockstate registry (Unlikely) will conflict\nI won't take responsibility for you rolling the dice and nuking your world"})
    @Config.Name(value="EXPERIMENTAL: BlockState Identity Registry Patch (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.blockstateidentity.json", defaultValue=false)
    public boolean blockStateIdentityRegistryPatch = false;
    @Config.Comment(value={"Fixes Optifine adding reflection to block storage methods causing wasted performance"})
    @Config.Name(value="Block Storage Optifine Lag Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.blockstorageoptifine.json", defaultValue=false)
    public boolean blockStorageOptifineLagFix = false;
    @Config.Comment(value={"Fixes server entity velocity being limited when sending velocity update packets to clients, making fast projectiles visibly strafe sideways when shot in specific directions"})
    @Config.Name(value="Entity Velocity Limit Fix (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.entityvelocitysync.json", defaultValue=false)
    public boolean entityVelocitySync = false;
    @Config.Comment(value={"Prints when automatic world saving starts and ends to the log, along with time taken, for better clarity during lag spikes"})
    @Config.Name(value="Automatic Save Logging (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.autosavelog.json", defaultValue=false)
    public boolean automaticSaveLogging = false;
    @Config.Comment(value={"Adjusts the server thread priority to max (10) to potentially improve performance when other less important threads are taking up resources"})
    @Config.Name(value="Server Thread Priority Tweak (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.serverpriority.json", defaultValue=false)
    public boolean serverThreadPriorityTweak = false;
    @Config.Comment(value={"Adjusts the client thread priority to high (8) to potentially improve performance when other less important threads are taking up resources\nWarning: It is highly recommended you only enable this if \"Server Thread Priority Tweak (Vanilla)\" is also enabled to avoid degrading server thread performance"})
    @Config.Name(value="Client Thread Priority Tweak (Vanilla)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(earlyMixin="mixins.fermiummixins.early.vanilla.clientpriority.json", defaultValue=false)
    public boolean clientThreadPriorityTweak = false;
    private Set<Potion> tippedArrowBlacklistedPotions = null;
    private List<String> particleRetainCollisionClasses = null;
    private Map<Integer, IBlockState> dimensionFillerBlockMap = null;
    private Set<Block> customCarverBlocks = null;
    private Map<Biome, Boolean> mineshaftBiomeBlacklistMap = null;
    private Set<BiomeDictionary.Type> mineshaftBiomeTypeBlacklistSet = null;
    private Map<Biome, Boolean> respawnBiomeBlacklistMap = null;
    private Set<BiomeDictionary.Type> respawnBiomeTypeBlacklistSet = null;
    private Field fieldEntityClassRegistrations = null;
    private Field fieldTrackingRange = null;

    public Set<Potion> getTippedArrowBlacklistedPotions() {
        if (this.tippedArrowBlacklistedPotions == null) {
            this.tippedArrowBlacklistedPotions = new HashSet<Potion>();
            for (String potionName : this.tippedArrowBlacklist) {
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionName));
                if (potion == null) continue;
                this.tippedArrowBlacklistedPotions.add(potion);
            }
        }
        return this.tippedArrowBlacklistedPotions;
    }

    public List<String> getParticleRetainCollisionClasses() {
        if (this.particleRetainCollisionClasses == null) {
            this.particleRetainCollisionClasses = Arrays.asList(this.particleRetainCollisionList);
        }
        return this.particleRetainCollisionClasses;
    }

    public IBlockState getDimensionFillerBlock(int dimension) {
        if (this.dimensionFillerBlockMap == null) {
            this.dimensionFillerBlockMap = new HashMap<Integer, IBlockState>();
            for (String entry : this.customDimensionFillerBlockList) {
                try {
                    ResourceLocation loc;
                    Block block;
                    String[] arr;
                    if (entry.isEmpty() || (arr = entry.split(",")).length != 2) continue;
                    int id = Integer.parseInt(arr[0].trim());
                    String name = arr[1].trim();
                    if (name.isEmpty() || (block = (Block)ForgeRegistries.BLOCKS.getValue(loc = new ResourceLocation(name))) == null) continue;
                    this.dimensionFillerBlockMap.put(id, block.func_176223_P());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.dimensionFillerBlockMap.get(dimension);
    }

    public boolean isBlockCarvable(Block blockIn) {
        if (this.customCarverBlocks == null) {
            this.customCarverBlocks = new HashSet<Block>();
            for (String entry : this.additionalCarverBlocksList) {
                try {
                    ResourceLocation loc;
                    Block block;
                    String name;
                    if (entry.isEmpty() || (name = entry.trim()).isEmpty() || (block = (Block)ForgeRegistries.BLOCKS.getValue(loc = new ResourceLocation(name))) == null) continue;
                    this.customCarverBlocks.add(block);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.customCarverBlocks.contains(blockIn);
    }

    public boolean isMineshaftsBlacklistedFromBiome(Biome biome) {
        Boolean val;
        if (biome == null) {
            return false;
        }
        if (this.mineshaftBiomeBlacklistMap == null) {
            this.mineshaftBiomeBlacklistMap = new HashMap<Biome, Boolean>();
            for (String name : this.mineshaftBiomeNameBlacklist) {
                Biome reg = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(name));
                if (reg == null) continue;
                this.mineshaftBiomeBlacklistMap.put(reg, true);
            }
        }
        if ((val = this.mineshaftBiomeBlacklistMap.get(biome)) != null) {
            return val;
        }
        Set types = BiomeDictionary.getTypes((Biome)biome);
        for (BiomeDictionary.Type type : this.getMineshaftBiomeTypesBlacklist()) {
            if (!types.contains(type)) continue;
            this.mineshaftBiomeBlacklistMap.put(biome, true);
            return true;
        }
        this.mineshaftBiomeBlacklistMap.put(biome, false);
        return false;
    }

    private Set<BiomeDictionary.Type> getMineshaftBiomeTypesBlacklist() {
        if (this.mineshaftBiomeTypeBlacklistSet == null) {
            this.mineshaftBiomeTypeBlacklistSet = new HashSet<BiomeDictionary.Type>();
            for (String string : this.mineshaftBiomeTypeBlacklist) {
                this.mineshaftBiomeTypeBlacklistSet.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
            }
        }
        return this.mineshaftBiomeTypeBlacklistSet;
    }

    public boolean isRespawnBlacklistedFromBiome(Biome biome) {
        Boolean val;
        if (this.respawnBiomeBlacklistMap == null) {
            this.respawnBiomeBlacklistMap = new HashMap<Biome, Boolean>();
            for (String name : this.respawnProtectionBiomeBlacklist) {
                Biome reg = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(name));
                if (reg == null) continue;
                this.respawnBiomeBlacklistMap.put(reg, true);
            }
        }
        if ((val = this.respawnBiomeBlacklistMap.get(biome)) != null) {
            return val;
        }
        Set types = BiomeDictionary.getTypes((Biome)biome);
        for (BiomeDictionary.Type type : this.getRespawnBiomeTypeBlacklistSet()) {
            if (!types.contains(type)) continue;
            this.respawnBiomeBlacklistMap.put(biome, true);
            return true;
        }
        this.respawnBiomeBlacklistMap.put(biome, false);
        return false;
    }

    private Set<BiomeDictionary.Type> getRespawnBiomeTypeBlacklistSet() {
        if (this.respawnBiomeTypeBlacklistSet == null) {
            this.respawnBiomeTypeBlacklistSet = new HashSet<BiomeDictionary.Type>();
            for (String string : this.respawnProtectionBiomeTypeBlacklist) {
                this.respawnBiomeTypeBlacklistSet.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
            }
        }
        return this.respawnBiomeTypeBlacklistSet;
    }

    private void handleGammaOverrides() {
        FermiumMixins.PROXY.setGamma(this.minimumGammaValue, this.maximumGammaValue);
    }

    private void handleEntityViewDistanceOverrides() {
        try {
            if (this.fieldEntityClassRegistrations == null) {
                this.fieldEntityClassRegistrations = EntityRegistry.class.getDeclaredField("entityClassRegistrations");
                this.fieldEntityClassRegistrations.setAccessible(true);
            }
            BiMap registry = (BiMap)this.fieldEntityClassRegistrations.get(EntityRegistry.instance());
            for (EntityRegistry.EntityRegistration entityRegister : registry.values()) {
                Integer distance = this.getEntityViewDistanceOverride(entityRegister.getRegistryName());
                if (distance == null) continue;
                if (this.fieldTrackingRange == null) {
                    this.fieldTrackingRange = EntityRegistry.EntityRegistration.class.getDeclaredField("trackingRange");
                    this.fieldTrackingRange.setAccessible(true);
                }
                this.fieldTrackingRange.set(entityRegister, distance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    private Integer getEntityViewDistanceOverride(ResourceLocation id) {
        if (id == null) {
            return null;
        }
        return this.entityViewDistanceOverrideList.get(id.toString());
    }

    public void refreshConfig() {
        this.tippedArrowBlacklistedPotions = null;
        this.particleRetainCollisionClasses = null;
        this.dimensionFillerBlockMap = null;
        this.customCarverBlocks = null;
        this.mineshaftBiomeBlacklistMap = null;
        this.mineshaftBiomeTypeBlacklistSet = null;
        this.respawnBiomeBlacklistMap = null;
        this.respawnBiomeTypeBlacklistSet = null;
        if (this.allowClampingGamma) {
            this.handleGammaOverrides();
        }
        if (this.allowEntityViewDistanceOverride) {
            this.handleEntityViewDistanceOverrides();
        }
    }
}

