/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.config;

import fermiumbooter.annotations.MixinConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@MixinConfig(name="fermiummixins")
public class ReskillableConfig {
    @Config.Comment(value={"Fixes player data being reset when returning from the end, causing baubles with level requirements to be lost"})
    @Config.Name(value="Player Tracking Patch (Reskillable)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.reskillable.tracking.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="reskillable", desired=true, reason="Requires mod to properly function")
    public boolean playerTrackingPatch = false;
    @Config.Comment(value={"Allows skill locked plantable food to still be eaten but not planted"})
    @Config.Name(value="SeedFood Bypass Lock (Reskillable)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.reskillable.seedfood.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="reskillable", desired=true, reason="Requires mod to properly function")
    public boolean seedFoodBypassLock = false;
    @Config.Comment(value={"Adds a config blacklist for what will be eaten, changes food prioritization, and optionally fires ItemUseFinish event afterwards for compat"})
    @Config.Name(value="HungryFarmer Rework (Reskillable)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.reskillable.hungryfarmer.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="reskillable", desired=true, reason="Requires mod to properly function")
    public boolean hungryFarmerRework = false;
    @Config.Comment(value={"Food blacklist for the HungryFarmer trait\nRequires \"HungryFarmer Rework (Reskillable)\" enabled"})
    @Config.Name(value="HungryFarmer Food Blacklist")
    public String[] hungryFarmerFoodBlacklist = new String[]{""};
    @Config.Comment(value={"Fires ItemUseFinish event after eating with HungryFarmer to account for thirst and other effects\nRequires \"HungryFarmer Rework (Reskillable)\" enabled"})
    @Config.Name(value="HungryFarmer Fires Forge Events")
    public boolean hungryFarmerFiresForgeEvents = false;
    @Config.Comment(value={"Fixes Reskillable cancelling indirect self damage"})
    @Config.Name(value="Indirect Self Damage Patch (Reskillable)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.reskillable.selfdamage.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="reskillable", desired=true, reason="Requires mod to properly function")
    public boolean indirectSelfDamagePatch = false;
    @Config.Comment(value={"Reworks road walk perk to be based on a configurable list instead of only on grass path blocks"})
    @Config.Name(value="RoadWalk Rework (Reskillable)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.reskillable.roadwalk.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="reskillable", desired=true, reason="Requires mod to properly function")
    public boolean roadWalkRework = false;
    @Config.Comment(value={"Blocks defined in this list will trigger the road walk effect when walked on\nRequires \"RoadWalk Rework (Reskillable)\" enabled"})
    @Config.Name(value="RoadWalk Block List")
    public String[] roadWalkList = new String[]{"minecraft:grass_path"};
    @Config.Comment(value={"If enabled, allows for the road walk effect to be triggered when exposed to the sky regardless of the block underneath\nRequires \"RoadWalk Rework (Reskillable)\" enabled"})
    @Config.Name(value="RoadWalk Sky Override")
    public boolean roadWalkSkyOverride = false;
    @Config.Comment(value={"Makes Golden Osmosis perk also repair DefiledLand's Golden BookWyrm armor"})
    @Config.Name(value="Golden BookWyrm Osmosis (Reskillable/DefiledLands)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.reskillable.goldenbookwyrm.json", defaultValue=false)
    @MixinConfig.CompatHandlingContainer(value={@MixinConfig.CompatHandling(modid="reskillable", desired=true, reason="Requires mod to properly function"), @MixinConfig.CompatHandling(modid="defiledlands", desired=true, reason="Requires mod to properly function")})
    public boolean goldenBookWyrmOsmosis = false;
    @Config.Comment(value={"Reworks Undershirt perk to work properly with FirstAid"})
    @Config.Name(value="Undershirt Compat (Reskillable/FirstAid)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.reskillable.undershirt.json", defaultValue=false)
    @MixinConfig.CompatHandlingContainer(value={@MixinConfig.CompatHandling(modid="reskillable", desired=true, reason="Requires mod to properly function"), @MixinConfig.CompatHandling(modid="firstaid", desired=true, reason="Requires mod to properly function")})
    public boolean undershirtCompat = false;
    private Set<ResourceLocation> hungryFarmerFoodBlacklistSet = null;
    private Set<Block> roadWalkBlockSet = null;

    public Set<ResourceLocation> getHungryFarmerBlacklist() {
        if (this.hungryFarmerFoodBlacklistSet == null) {
            this.hungryFarmerFoodBlacklistSet = new HashSet<ResourceLocation>();
            for (String loc : this.hungryFarmerFoodBlacklist) {
                if (loc.isEmpty()) continue;
                this.hungryFarmerFoodBlacklistSet.add(new ResourceLocation(loc));
            }
        }
        return this.hungryFarmerFoodBlacklistSet;
    }

    public Set<Block> getRoadWalkBlockSet() {
        if (this.roadWalkBlockSet == null) {
            this.roadWalkBlockSet = new HashSet<Block>();
            for (String name : this.roadWalkList) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
                if (block == null) continue;
                this.roadWalkBlockSet.add(block);
            }
        }
        return this.roadWalkBlockSet;
    }

    public void refreshConfig() {
        this.hungryFarmerFoodBlacklistSet = null;
        this.roadWalkBlockSet = null;
    }
}

