/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.config;

import fermiumbooter.annotations.MixinConfig;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="fermiummixins")
public class OpenTerrainGeneratorConfig {
    @Config.Comment(value={"Forces OpenTerrainGenerator to use Vanilla player spawn handling instead of its modified method"})
    @Config.Name(value="Force Vanilla Spawning (OpenTerrainGenerator)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.openterraingenerator.respawn.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="openterraingenerator", desired=true, reason="Requires mod to properly function")
    public boolean forceVanillaSpawning = false;
    @Config.Comment(value={"Disables OpenTerrainGenerator's pregenerator which wastes performance as it runs when not active"})
    @Config.Name(value="Force Disable Pregenerator (OpenTerrainGenerator)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.openterraingenerator.pregen.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="openterraingenerator", desired=true, reason="Requires mod to properly function")
    public boolean forceDisablePregenerator = false;
    @Config.Comment(value={"Adds additional checks to help prevent OpenTerrainGenerator's SaveToDisk crashing during pregeneration"})
    @Config.Name(value="Save To Disk Crash Improvement (OpenTerrainGenerator)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.openterraingenerator.savetodiskcrash.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="openterraingenerator", desired=true, reason="Requires mod to properly function")
    public boolean saveToDiskCrashImprovement = false;
    @Config.Comment(value={"Seconds that populate should wait to try to lock (Do not modify this if you do not know what you are doing)\nRequires \"Save To Disk Crash Improvement (OpenTerrainGenerator)\" enabled"})
    @Config.Name(value="Populate Lock Time")
    public int populateLockTime = 10;
    @Config.Comment(value={"Seconds that saveToDisk should wait to try to lock (Do not modify this if you do not know what you are doing)\nRequires \"Save To Disk Crash Improvement (OpenTerrainGenerator)\" enabled"})
    @Config.Name(value="SaveToDisk Lock Time")
    public int saveToDiskLockTime = 10;
    @Config.Comment(value={"Adds additional checks to help prevent OpenTerrainGenerator crashing during world-gen"})
    @Config.Name(value="World Gen Crash Improvement (OpenTerrainGenerator)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.openterraingenerator.worldgencrash.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="openterraingenerator", desired=true, reason="Requires mod to properly function")
    public boolean worldGenCrashImprovement = false;
    @Config.Comment(value={"Improves world load speed on large maps such as pregenerated servers"})
    @Config.Name(value="CustomStructureCache Improve Load Speed (OpenTerrainGenerator)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.openterraingenerator.cacheloadspeed.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="openterraingenerator", desired=true, reason="Requires mod to properly function")
    public boolean improveLoadSpeed = false;
}

