/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.config;

import fermiumbooter.annotations.MixinConfig;
import fermiummixins.FermiumMixins;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

@MixinConfig(name="fermiummixins")
public class DramaticTreesConfig {
    @Config.Comment(value={"Disables unnecessary lighting checks on leaves during worldgen for performance"})
    @Config.Name(value="WorldGen Leaves Lighting Lag Fix (DramaticTrees)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.dramatictrees.lighting.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="dynamictrees", desired=true, reason="Requires mod to properly function")
    public boolean worldGenLeavesLighting = false;
    @Config.Comment(value={"Cache leaf and branch AABBs to save on memory allocation usage"})
    @Config.Name(value="Collision Box Cache (DramaticTrees)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.dramatictrees.aabbcache.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="dynamictrees", desired=true, reason="Requires mod to properly function")
    public boolean collisionBoxCache = false;
    @Config.Comment(value={"Overhauls tree falling such as making volume dependant on speed/size and allowing for passing through or breaking additional blocks"})
    @Config.Name(value="Tree Falling Overhaul (DramaticTrees)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.dramatictrees.overhaul.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="dynamictrees", desired=true, reason="Requires mod to properly function")
    public boolean treeFallingOverhaul = false;
    @Config.Comment(value={"Prints the class names of solid blocks during tree collisions to console\nRequires \"Tree Falling Overhaul (DramaticTrees)\" enabled"})
    @Config.Name(value="Debug Tree Collision Names")
    public boolean treesCollisionNameDebug = false;
    @Config.Comment(value={"List of blocks for falling trees to treat as non-solid when falling\nRequires \"Tree Falling Overhaul (DramaticTrees)\" enabled"})
    @Config.Name(value="Tree Falling Non-Solid Blocks")
    public String[] treeFallingNonSolidBlocks = new String[]{"dynamictrees:leaves0", "minecraft:leaves", "minecraft:vine", "minecraft:double_plant", "minecraft:tallgrass", "notreepunching:loose_rock/stone", "notreepunching:loose_rock/sandstone"};
    @Config.Comment(value={"List of blocks from the non-solid list for falling trees to break while falling\nRequires \"Tree Falling Overhaul (DramaticTrees)\" enabled"})
    @Config.Name(value="Tree Falling Non-Solid Breakable Blocks")
    public String[] treeFallingNonSolidBreakableBlocks = new String[]{"dynamictrees:leaves0", "minecraft:leaves", "minecraft:vine", "minecraft:double_plant", "minecraft:tallgrass"};
    @Config.Comment(value={"List of blocks for falling trees to treat as solid but still break while falling\nRequires \"Tree Falling Overhaul (DramaticTrees)\" enabled"})
    @Config.Name(value="Tree Falling Solid Breakable Blocks")
    public String[] treeFallingSolidBreakableBlocks = new String[0];
    private HashSet<Block> treeFallingNonSolidList = null;
    private HashSet<Block> treeFallingNonSolidBreakableList = null;
    private HashSet<Block> treeFallingSolidBreakableList = null;

    public HashSet<Block> getTreeFallingNonSolidList() {
        if (this.treeFallingNonSolidList == null) {
            this.treeFallingNonSolidList = new HashSet();
            for (String string : this.treeFallingNonSolidBlocks) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
                if (block == null || block == Blocks.field_150350_a) {
                    FermiumMixins.LOGGER.log(Level.WARN, "FermiumMixins DramaticTree Non-Solid list invalid block: " + string + ", ignoring.");
                    continue;
                }
                this.treeFallingNonSolidList.add(block);
            }
        }
        return this.treeFallingNonSolidList;
    }

    public HashSet<Block> getTreeFallingNonSolidBreakableList() {
        if (this.treeFallingNonSolidBreakableList == null) {
            this.treeFallingNonSolidBreakableList = new HashSet();
            for (String string : this.treeFallingNonSolidBreakableBlocks) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
                if (block == null || block == Blocks.field_150350_a) {
                    FermiumMixins.LOGGER.log(Level.WARN, "FermiumMixins DramaticTree Non-Solid Breakable list invalid block: " + string + ", ignoring.");
                    continue;
                }
                this.treeFallingNonSolidBreakableList.add(block);
            }
        }
        return this.treeFallingNonSolidBreakableList;
    }

    public HashSet<Block> getTreeFallingSolidBreakableList() {
        if (this.treeFallingSolidBreakableList == null) {
            this.treeFallingSolidBreakableList = new HashSet();
            for (String string : this.treeFallingSolidBreakableBlocks) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
                if (block == null || block == Blocks.field_150350_a) {
                    FermiumMixins.LOGGER.log(Level.WARN, "FermiumMixins DramaticTree Solid Breakable list invalid block: " + string + ", ignoring.");
                    continue;
                }
                this.treeFallingSolidBreakableList.add(block);
            }
        }
        return this.treeFallingSolidBreakableList;
    }

    public void refreshConfig() {
        this.treeFallingNonSolidList = null;
        this.treeFallingNonSolidBreakableList = null;
        this.treeFallingSolidBreakableList = null;
    }
}

