/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.config;

import fermiumbooter.annotations.MixinConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@MixinConfig(name="fermiummixins")
public class BetterMineshaftsConfig {
    @Config.Comment(value={"Fixes mineshaft biome checks causing excess chunk generation"})
    @Config.Name(value="Excess Mineshaft Chunk Generation Fix (BetterMineshafts)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.bettermineshafts.performance.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="bettermineshafts", desired=true, reason="Requires mod to properly function")
    public boolean excessMineshaftChunkGenerationFix = false;
    @Config.Comment(value={"Allows for blacklisting biomes to prevent spawning of Mineshafts"})
    @Config.Name(value="Mineshaft Biome Blacklist Patch (BetterMineshafts)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.bettermineshafts.blacklist.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="bettermineshafts", desired=true, reason="Requires mod to properly function")
    public boolean betterMineshaftBiomeBlacklistPatch = false;
    @Config.Comment(value={"Biome name blacklist to prevent Mineshafts from spawning\nRequires \"Mineshaft Biome Blacklist Patch (BetterMineshafts)\" enabled"})
    @Config.Name(value="Mineshaft Biome Name Blacklist")
    public String[] betterMineshaftBiomeNameBlacklist = new String[]{""};
    @Config.Comment(value={"Biome type blacklist to prevent Mineshafts from spawning\nRequires \"Mineshaft Biome Blacklist Patch (BetterMineshafts)\" enabled"})
    @Config.Name(value="Mineshaft Biome Type Blacklist")
    public String[] betterMineshaftBiomeTypeBlacklist = new String[]{""};
    private Map<Biome, Boolean> mineshaftBiomeBlacklistMap = null;
    private Set<BiomeDictionary.Type> mineshaftBiomeTypeBlacklistSet = null;

    public boolean isMineshaftsBlacklistedFromBiome(Biome biome) {
        Boolean val;
        if (biome == null) {
            return false;
        }
        if (this.mineshaftBiomeBlacklistMap == null) {
            this.mineshaftBiomeBlacklistMap = new HashMap<Biome, Boolean>();
            for (String name : this.betterMineshaftBiomeNameBlacklist) {
                Biome reg = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(name));
                if (reg == null) continue;
                this.mineshaftBiomeBlacklistMap.put(reg, true);
            }
        }
        if ((val = this.mineshaftBiomeBlacklistMap.get(biome)) != null) {
            return val;
        }
        Set types = BiomeDictionary.getTypes((Biome)biome);
        for (BiomeDictionary.Type type : this.getMineshaftBiomeTypesBlacklist()) {
            if (!types.contains(type)) continue;
            this.mineshaftBiomeBlacklistMap.put(biome, true);
            return true;
        }
        this.mineshaftBiomeBlacklistMap.put(biome, false);
        return false;
    }

    private Set<BiomeDictionary.Type> getMineshaftBiomeTypesBlacklist() {
        if (this.mineshaftBiomeTypeBlacklistSet == null) {
            this.mineshaftBiomeTypeBlacklistSet = new HashSet<BiomeDictionary.Type>();
            for (String string : this.betterMineshaftBiomeTypeBlacklist) {
                this.mineshaftBiomeTypeBlacklistSet.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
            }
        }
        return this.mineshaftBiomeTypeBlacklistSet;
    }

    public void refreshConfig() {
        this.mineshaftBiomeBlacklistMap = null;
        this.mineshaftBiomeTypeBlacklistSet = null;
    }
}

