/*
 * Decompiled with CFR 0.152.
 */
package fermiummixins.config;

import fermiumbooter.annotations.MixinConfig;
import fermiummixins.handlers.ConfigHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;

@MixinConfig(name="fermiummixins")
public class AdvancedRocketryConfig {
    @Config.Comment(value={"Allows for setting orbital period overrides"})
    @Config.Name(value="Orbital Overrides Patch (AdvancedRocketry)")
    @Config.RequiresMcRestart
    @MixinConfig.MixinToggle(lateMixin="mixins.fermiummixins.late.advancedrocketry.orbitaloverride.json", defaultValue=false)
    @MixinConfig.CompatHandling(modid="advancedrocketry", desired=true, reason="Requires mod to properly function")
    public boolean orbitalOverridesPatch = false;
    @Config.Comment(value={"Allows for overriding the orbital period calculation result\nFormat: String name, double value\nRequires \"Orbital Overrides Patch (AdvancedRocketry)\" enabled"})
    @Config.Name(value="Orbital Period Overrides")
    public String[] orbitalPeriodOverrides = new String[0];
    @Config.Comment(value={"Allows for multiplying the orbital period calculation result if not overridden\nFormat: String name, double multiplier\nRequires \"Orbital Overrides Patch (AdvancedRocketry)\" enabled"})
    @Config.Name(value="Orbital Period Multipliers")
    public String[] orbitalPeriodMults = new String[0];
    private Map<String, Double> orbitalPeriodOverrideMap = null;
    private Map<String, Double> orbitalPeriodMultMap = null;

    public Double getOrbitalPeriodOverride(String nameIn) {
        if (this.orbitalPeriodOverrideMap == null) {
            this.orbitalPeriodOverrideMap = new HashMap<String, Double>();
            for (String entry : ConfigHandler.ADVANCEDROCKETRY_CONFIG.orbitalPeriodOverrides) {
                try {
                    String name;
                    String[] arr;
                    if (entry.isEmpty() || (arr = entry.split(",")).length != 2 || (name = arr[0].trim()).isEmpty()) continue;
                    double mult = Double.parseDouble(arr[1].trim());
                    this.orbitalPeriodOverrideMap.put(name, mult);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.orbitalPeriodOverrideMap.get(nameIn);
    }

    public Double getOrbitalPeriodMult(String nameIn) {
        if (this.orbitalPeriodMultMap == null) {
            this.orbitalPeriodMultMap = new HashMap<String, Double>();
            for (String entry : ConfigHandler.ADVANCEDROCKETRY_CONFIG.orbitalPeriodMults) {
                try {
                    String name;
                    String[] arr;
                    if (entry.isEmpty() || (arr = entry.split(",")).length != 2 || (name = arr[0].trim()).isEmpty()) continue;
                    double mult = Double.parseDouble(arr[1].trim());
                    this.orbitalPeriodMultMap.put(name, mult);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.orbitalPeriodMultMap.get(nameIn);
    }

    public void refreshConfig() {
        this.orbitalPeriodOverrideMap = null;
        this.orbitalPeriodMultMap = null;
    }
}

