/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.structuremarkers.network;

import antiqueatlasautomarker.AntiqueAtlasAutoMarker;
import antiqueatlasautomarker.compat.AARCCompat;
import antiqueatlasautomarker.compat.ModCompat;
import antiqueatlasautomarker.config.AutoMarkSetting;
import antiqueatlasautomarker.config.ConfigHandler;
import antiqueatlasautomarker.structuremarkers.event.ReceivedStructureMarkerEvent;
import antiqueatlasautomarker.structuremarkers.network.AddedStructureMarkersPacket;
import antiqueatlasautomarker.util.IMarkerConstructor;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.network.PacketDispatcher;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class OptionalStructureMarkerPacket
extends AbstractMessage.AbstractClientMessage<OptionalStructureMarkerPacket> {
    private int atlasID;
    private int dimension;
    private final ListMultimap<String, Marker> markersByType = ArrayListMultimap.create();

    public OptionalStructureMarkerPacket() {
    }

    public OptionalStructureMarkerPacket(int atlasID, int dimension, Marker ... markers) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        for (Marker marker : markers) {
            this.markersByType.put((Object)marker.getType(), (Object)marker);
        }
    }

    public OptionalStructureMarkerPacket putMarker(Marker marker) {
        this.markersByType.put((Object)marker.getType(), (Object)marker);
        return this;
    }

    public void read(PacketBuffer buffer) throws IOException {
        this.atlasID = buffer.func_150792_a();
        this.dimension = buffer.func_150792_a();
        int typesLength = buffer.func_150792_a();
        for (int i = 0; i < typesLength; ++i) {
            String type = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            int markersLength = buffer.func_150792_a();
            for (int j = 0; j < markersLength; ++j) {
                Marker marker = new Marker(buffer.func_150792_a(), type, ByteBufUtils.readUTF8String((ByteBuf)buffer), this.dimension, buffer.readInt(), buffer.readInt(), buffer.readBoolean());
                this.markersByType.put((Object)type, (Object)marker);
            }
        }
    }

    public void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.atlasID);
        buffer.func_150787_b(this.dimension);
        Set types = this.markersByType.keySet();
        buffer.func_150787_b(types.size());
        for (String type : types) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)type);
            List markers = this.markersByType.get((Object)type);
            buffer.func_150787_b(markers.size());
            for (Marker marker : markers) {
                buffer.func_150787_b(marker.getId());
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)marker.getLabel());
                buffer.writeInt(marker.getX());
                buffer.writeInt(marker.getZ());
                buffer.writeBoolean(marker.isVisibleAhead());
            }
        }
    }

    protected void process(EntityPlayer player, Side side) {
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, player.field_70170_p);
        AddedStructureMarkersPacket updatePacket = new AddedStructureMarkersPacket(this.atlasID, player.field_70170_p.field_73011_w.getDimension(), new Marker[0]);
        int addedMarkerCount = 0;
        if (ConfigHandler.internal.doDebugLogs) {
            AntiqueAtlasAutoMarker.LOGGER.info("Receiving {} structure markers for atlas #{}", (Object)this.markersByType.size(), (Object)this.atlasID);
        }
        for (Marker marker : this.markersByType.values()) {
            AutoMarkSetting clientSetting;
            String[] context_type = IMarkerConstructor.splitContext(marker.getType());
            String context = context_type[0];
            String serverType = context_type[1];
            String serverLabel = marker.getLabel();
            if (ConfigHandler.internal.doDebugLogs) {
                AntiqueAtlasAutoMarker.LOGGER.info("Trying to add marker {} {} {}", (Object)context, (Object)serverLabel, (Object)serverType);
            }
            if (ModCompat.aarc.isLoaded() && context.startsWith("AARCAddon")) {
                if (!ConfigHandler.aarcaddon.enabled) continue;
                clientSetting = AARCCompat.getAARCSetting(context);
            } else if (context.startsWith("aa_")) {
                clientSetting = new AutoMarkSetting(context.equals("aa_global") || SettingsConfig.gameplay.autoVillageMarkers, "DEFAULT", "DEFAULT", context);
            } else if (context.startsWith("ruins_")) {
                if (!ConfigHandler.ruins.enabled) continue;
                clientSetting = AutoMarkSetting.get(context);
            } else {
                clientSetting = context.equals("customPos") ? new AutoMarkSetting(true, "DEFAULT", "DEFAULT", context) : (context.isEmpty() ? new AutoMarkSetting(true, "DEFAULT", "DEFAULT", context) : AutoMarkSetting.get(context));
            }
            if (ConfigHandler.internal.doDebugLogs) {
                if (clientSetting == null) {
                    AntiqueAtlasAutoMarker.LOGGER.info("Client setting for marker is null");
                } else {
                    AntiqueAtlasAutoMarker.LOGGER.info("Found client setting for marker {} {} {} {}", (Object)clientSetting.enabled, (Object)clientSetting.context, (Object)clientSetting.label, (Object)clientSetting.type);
                }
            }
            if (clientSetting == null || !clientSetting.enabled || ConfigHandler.internal.fireReceivedMarkerEvent && MinecraftForge.EVENT_BUS.post((Event)new ReceivedStructureMarkerEvent(player, marker, context))) continue;
            String clientType = clientSetting.type.equals("DEFAULT") ? serverType : clientSetting.type;
            String clientLabel = clientSetting.label.equals("DEFAULT") ? serverLabel : clientSetting.label;
            Marker newMarker = ((IMarkerConstructor)marker).structureMarkerCopy(clientType, clientLabel);
            markersData.loadMarker(newMarker);
            updatePacket.putMarker(newMarker);
            ++addedMarkerCount;
        }
        if (ConfigHandler.internal.doDebugLogs) {
            AntiqueAtlasAutoMarker.LOGGER.info("Added {} new structure markers", (Object)addedMarkerCount);
        }
        if (addedMarkerCount > 0) {
            PacketDispatcher.sendToServer((IMessage)updatePacket);
        }
    }
}

