/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.structuremarkers;

import antiqueatlasautomarker.AntiqueAtlasAutoMarker;
import antiqueatlasautomarker.config.AutoMarkSetting;
import antiqueatlasautomarker.config.ConfigHandler;
import antiqueatlasautomarker.structuremarkers.CustomPosition;
import antiqueatlasautomarker.util.IDeletedMarkerList;
import antiqueatlasautomarker.util.IMarkerConstructor;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class StructureMarkersDataHandler {
    private static final String DATA_KEY = "aAtlasStructureMarkers";

    public static MarkersData getData(World world) {
        MarkersData data = (MarkersData)world.func_72943_a(MarkersData.class, DATA_KEY);
        if (data == null) {
            data = new MarkersData(DATA_KEY);
            data.func_76185_a();
            world.func_72823_a(DATA_KEY, (WorldSavedData)data);
        }
        return data;
    }

    public static Marker markStructure(@Nonnull World world, int x, int z, String markerType, String markerName, String context, int ... providedDimension) {
        int checkPosZ;
        int checkPosX;
        if (world.field_72995_K) {
            if (ConfigHandler.internal.doDebugLogs) {
                AntiqueAtlasAutoMarker.LOGGER.info("Trying to access structure marker data from clientside! context {}", (Object)context);
            }
            return null;
        }
        MarkersData data = StructureMarkersDataHandler.getData(world);
        boolean isCustomPositionMarker = providedDimension != null && providedDimension.length == 1;
        int dimension = !isCustomPositionMarker ? world.field_73011_w.getDimension() : providedDimension[0];
        markerType = IMarkerConstructor.addContext(markerType, context);
        boolean hasMarkerAlready = false;
        if (CustomPosition.isEmpty()) {
            checkPosX = (x >> 4) / 8;
            checkPosZ = (z >> 4) / 8;
        } else {
            checkPosX = CustomPosition.get().bigChunkX;
            checkPosZ = CustomPosition.get().bigChunkZ;
        }
        List markersHere = data.getMarkersAtChunk(dimension, checkPosX, checkPosZ);
        if (markersHere != null) {
            for (Marker marker : markersHere) {
                if (marker.getX() != x || marker.getZ() != z || !marker.getType().equals(markerType) || !marker.getLabel().equals(markerName)) continue;
                hasMarkerAlready = true;
            }
        }
        if (ConfigHandler.internal.doDebugLogs) {
            AntiqueAtlasAutoMarker.LOGGER.info("Marking Structure at {},{} with marker {} {} {}, already exists {}", (Object)x, (Object)z, (Object)context, (Object)markerName, (Object)markerType, (Object)hasMarkerAlready);
        }
        if (!hasMarkerAlready) {
            return data.createAndSaveMarker(markerType, markerName, dimension, x, z, isCustomPositionMarker);
        }
        return null;
    }

    public static Marker markStructure(@Nonnull World world, BlockPos pos, String markerType, String markerName, String context) {
        return StructureMarkersDataHandler.markStructure(world, pos.func_177958_n(), pos.func_177952_p(), markerType, markerName, context, new int[0]);
    }

    public static Marker markStructure(@Nonnull World world, int x, int z, AutoMarkSetting settings) {
        if (settings != null && settings.enabled) {
            return StructureMarkersDataHandler.markStructure(world, x, z, settings.type, settings.label, settings.context, new int[0]);
        }
        return null;
    }

    public static Marker markStructure(@Nonnull World world, BlockPos pos, AutoMarkSetting settings) {
        return StructureMarkersDataHandler.markStructure(world, pos.func_177958_n(), pos.func_177952_p(), settings);
    }

    public static Marker markCustomPositionStructure(@Nonnull World world, int dim, int x, int z, int xDiscover, int zDiscover, String markerType, String markerName) {
        CustomPosition.set(xDiscover, zDiscover);
        Marker createdMarker = StructureMarkersDataHandler.markStructure(world, x, z, markerType, markerName, "customPos", dim);
        CustomPosition.clear();
        return createdMarker;
    }

    public static ArrayList<Marker> updateMarkersAroundPlayer(EntityPlayer player, MarkersData atlasMarkers) {
        ArrayList<Marker> updatedMarkers = new ArrayList<Marker>();
        int newScanInterval = Math.round(SettingsConfig.performance.newScanInterval * 20.0f);
        if (player.field_70173_aa % newScanInterval != 0) {
            return updatedMarkers;
        }
        int playerBigChunkX = (player.func_180425_c().func_177958_n() >> 4) / 8;
        int playerBigChunkZ = (player.func_180425_c().func_177952_p() >> 4) / 8;
        int checkRadius = SettingsConfig.performance.scanRadius / 8;
        int dimension = player.field_70170_p.field_73011_w.getDimension();
        DimensionMarkersData markersInDimension = StructureMarkersDataHandler.getData(player.field_70170_p).getMarkersDataInDimension(dimension);
        for (int i = -checkRadius; i <= checkRadius; ++i) {
            for (int j = -checkRadius; j <= checkRadius; ++j) {
                int bigChunkX = playerBigChunkX + i;
                int bigChunkZ = playerBigChunkZ + j;
                List structureMarkers = markersInDimension.getMarkersAtChunk(bigChunkX, bigChunkZ);
                if (structureMarkers == null) continue;
                if (ConfigHandler.internal.doDebugLogs) {
                    AntiqueAtlasAutoMarker.LOGGER.info("Found Markers to send in bigchunk {},{} count {}", (Object)bigChunkX, (Object)bigChunkZ, (Object)structureMarkers.size());
                }
                List existingMarkers = atlasMarkers.getMarkersAtChunk(dimension, bigChunkX, bigChunkZ);
                for (Marker marker : structureMarkers) {
                    if (existingMarkers != null && StructureMarkersDataHandler.listContainsMarker(existingMarkers, marker) || ((IDeletedMarkerList)atlasMarkers).markerIsDeleted(-marker.getId())) continue;
                    if (ConfigHandler.internal.doDebugLogs) {
                        AntiqueAtlasAutoMarker.LOGGER.info("Adding marker to to-send list {}", (Object)marker);
                    }
                    updatedMarkers.add(marker);
                }
            }
        }
        return updatedMarkers;
    }

    private static boolean listContainsMarker(List<Marker> list, Marker markerServer) {
        for (Marker markerPlayer : list) {
            if (!StructureMarkersDataHandler.markerEquals(markerPlayer, markerServer)) continue;
            return true;
        }
        return false;
    }

    private static boolean markerEquals(Marker markerPlayer, Marker markerServer) {
        if (markerPlayer.getId() >= 0) {
            return false;
        }
        return markerPlayer.getId() == -markerServer.getId();
    }

    public static void removeStructureMarker(World world, String context, BlockPos coords, int radius) {
        if (world.field_72995_K) {
            return;
        }
        List<Marker> markersHere = StructureMarkersDataHandler.getData(world).getMarkersDataInDimension(world.field_73011_w.getDimension()).getMarkersAtChunk((coords.func_177958_n() >> 4) / 8, (coords.func_177952_p() >> 4) / 8);
        if (markersHere == null) {
            return;
        }
        markersHere = markersHere.stream().filter(marker -> IMarkerConstructor.splitContext(marker.getType())[0].equals(context)).filter(marker -> Math.abs(marker.getX() - coords.func_177958_n()) <= radius && Math.abs(marker.getZ() - coords.func_177952_p()) <= radius).collect(Collectors.toList());
        if (ConfigHandler.internal.doDebugLogs) {
            AntiqueAtlasAutoMarker.LOGGER.info("Removing {} structure markers", (Object)markersHere.size());
        }
        markersHere.forEach(marker -> StructureMarkersDataHandler.getData(world).removeMarker(marker.getId()));
    }
}

