/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.structuremarkers;

public class CustomPosition {
    public int bigChunkX;
    public int bigChunkZ;
    private static final ThreadLocal<CustomPosition> customPositionThreadLocal = ThreadLocal.withInitial(() -> null);

    public CustomPosition(int x, int z) {
        this.bigChunkX = (x >> 4) / 8;
        this.bigChunkZ = (z >> 4) / 8;
    }

    public CustomPosition() {
    }

    public CustomPosition setBigChunkCoords(int bigX, int bigZ) {
        this.bigChunkX = bigX;
        this.bigChunkZ = bigZ;
        return this;
    }

    public static CustomPosition get() {
        return customPositionThreadLocal.get();
    }

    public static void clear() {
        customPositionThreadLocal.remove();
    }

    public static boolean isEmpty() {
        return customPositionThreadLocal.get() == null;
    }

    public static void set(int x, int z) {
        customPositionThreadLocal.set(new CustomPosition(x, z));
    }
}

