/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.mixin.vanilla;

import antiqueatlasautomarker.config.ConfigHandler;
import antiqueatlasautomarker.config.EnchMarkSetting;
import antiqueatlasautomarker.util.EnchantmentOffer;
import antiqueatlasautomarker.util.EnchantmentUtil;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.village.MerchantRecipeList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetHandlerPlayClient.class})
public abstract class NetHandlerPlayClientMixin {
    @Shadow
    private Minecraft field_147299_f;

    @Inject(method={"handleCustomPayload"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/IMerchant;setRecipes(Lnet/minecraft/village/MerchantRecipeList;)V")})
    public void onMerchantTradeOffers(SPacketCustomPayload packetIn, CallbackInfo ci, @Local MerchantRecipeList tradeList, @Local IMerchant merchant) {
        if (!ConfigHandler.enchantments.enabled) {
            return;
        }
        EntityPlayerSP player = this.field_147299_f.field_71439_g;
        if (player == null) {
            return;
        }
        if (tradeList == null) {
            return;
        }
        ArrayList<EnchantmentOffer> offeredEnchants = new ArrayList<EnchantmentOffer>();
        for (Object trade : tradeList) {
            if (!(trade.func_77397_d().func_77973_b() instanceof ItemEnchantedBook)) continue;
            Map enchants = EnchantmentHelper.func_82781_a((ItemStack)trade.func_77397_d());
            ItemStack stackBuy1 = trade.func_77394_a();
            ItemStack stackBuy2 = trade.func_77396_b();
            int cost = Math.max(stackBuy1.func_190916_E(), stackBuy2.func_190916_E());
            for (Map.Entry entry : enchants.entrySet()) {
                offeredEnchants.add(new EnchantmentOffer((Enchantment)entry.getKey(), (Integer)entry.getValue(), cost));
            }
        }
        if (offeredEnchants.isEmpty()) {
            return;
        }
        ArrayList<EnchantmentOffer> toRemove = new ArrayList<EnchantmentOffer>();
        for (EnchantmentOffer offer1 : offeredEnchants) {
            for (EnchantmentOffer offer2 : offeredEnchants) {
                if (offer1 == offer2 || offer1.enchantment != offer2.enchantment) continue;
                if (offer1.lvl > offer2.lvl) {
                    toRemove.add(offer2);
                    continue;
                }
                if (offer1.lvl != offer2.lvl || offer1.cost >= offer2.cost) continue;
                toRemove.add(offer2);
            }
        }
        offeredEnchants.removeAll(toRemove);
        String markerLabel = "";
        boolean isFirst = true;
        for (EnchantmentOffer offer : offeredEnchants) {
            EnchMarkSetting setting;
            ResourceLocation enchReg = offer.enchantment.getRegistryName();
            if (enchReg == null || ((setting = EnchMarkSetting.get(enchReg.toString())) == null || offer.lvl < setting.minLvl) && !EnchMarkSetting.acceptAll) continue;
            String enchLabel = "";
            if (setting != null) {
                enchLabel = setting.abbreviation;
            }
            if (enchLabel.isEmpty()) {
                enchLabel = offer.enchantment.func_77316_c(offer.lvl);
            } else if (offer.enchantment.func_77325_b() > 1) {
                enchLabel = enchLabel + " " + I18n.func_135052_a((String)("enchantment.level." + offer.lvl), (Object[])new Object[0]);
            }
            enchLabel = enchLabel + " " + TextFormatting.GREEN + offer.cost + TextFormatting.RESET;
            if (isFirst) {
                markerLabel = markerLabel + enchLabel;
                isFirst = false;
                continue;
            }
            markerLabel = markerLabel + ", " + enchLabel;
        }
        if (markerLabel.isEmpty()) {
            return;
        }
        EnchantmentUtil.markLibrarian((EntityPlayer)player, merchant.func_190671_u_(), markerLabel);
    }
}

