/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.mixin.antiqueatlas.structuremarkers;

import antiqueatlasautomarker.util.IDeletedMarkerList;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import hunternif.mc.atlas.marker.MarkersData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MarkersData.class})
public abstract class MarkersDataMixin
extends WorldSavedData
implements IDeletedMarkerList {
    @Unique
    private List<Integer> removedMarkerIds = null;

    public MarkersDataMixin(String name) {
        super(name);
    }

    @Override
    public boolean markerIsDeleted(int markerID) {
        return this.removedMarkerIds != null && this.removedMarkerIds.contains(markerID);
    }

    @Override
    public void addDeletedMarker(int markerID) {
        if (this.removedMarkerIds == null) {
            this.removedMarkerIds = new ArrayList<Integer>();
        }
        this.removedMarkerIds.add(markerID);
        this.func_76185_a();
    }

    @ModifyReturnValue(method={"writeToNBT"}, at={@At(value="RETURN")})
    private NBTTagCompound writeDeletedIdsToNBT(NBTTagCompound original) {
        if (this.removedMarkerIds == null || this.removedMarkerIds.isEmpty()) {
            return original;
        }
        NBTTagList idList = new NBTTagList();
        for (Integer removedId : this.removedMarkerIds) {
            idList.func_74742_a((NBTBase)new NBTTagInt(removedId.intValue()));
        }
        original.func_74782_a("aaam_removedIds", (NBTBase)idList);
        return original;
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void readDeletedIdsFromNBT(NBTTagCompound compound, CallbackInfo ci) {
        if (!compound.func_74764_b("aaam_removedIds")) {
            return;
        }
        NBTTagList idList = compound.func_150295_c("aaam_removedIds", 3);
        if (this.removedMarkerIds == null) {
            this.removedMarkerIds = new ArrayList<Integer>();
        }
        for (int i = 0; i < idList.func_74745_c(); ++i) {
            this.removedMarkerIds.add(idList.func_186858_c(i));
        }
        this.func_76185_a();
    }
}

