/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.mixin.antiqueatlas.overhaul.structurewatcher;

import antiqueatlasautomarker.compat.ModCompat;
import antiqueatlasautomarker.compat.OpenTerrainGeneratorCompat;
import antiqueatlasautomarker.mixin.antiqueatlas.overhaul.structurewatcher.StructureWatcherFortressAccessor;
import antiqueatlasautomarker.mixin.antiqueatlas.overhaul.structurewatcher.StructureWatcherGenericAccessor;
import antiqueatlasautomarker.mixin.antiqueatlas.overhaul.structurewatcher.StructureWatcherVillageAccessor;
import antiqueatlasautomarker.util.StructureWatcherReference;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenEndCity;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapGenStructure.class})
public abstract class MapGenStructureMixin {
    @Unique
    private boolean aaam$isInCorrectChunk = false;
    @Unique
    private World aaam$savedWorld = null;

    @Inject(method={"generateStructure"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/gen/structure/MapGenStructure;setStructureStart(IILnet/minecraft/world/gen/structure/StructureStart;)V")})
    private void aaam_saveCorrectChunk(World worldIn, Random randomIn, ChunkPos chunkCoord, CallbackInfoReturnable<Boolean> cir, @Local StructureStart start) {
        if (chunkCoord.field_77276_a == start.func_143019_e() && chunkCoord.field_77275_b == start.func_143018_f()) {
            this.aaam$isInCorrectChunk = true;
            this.aaam$savedWorld = worldIn;
        }
    }

    @Inject(method={"generateStructure"}, at={@At(value="TAIL")})
    private void aaam_resetCache(World worldIn, Random randomIn, ChunkPos chunkCoord, CallbackInfoReturnable<Boolean> cir) {
        this.aaam$isInCorrectChunk = false;
        this.aaam$savedWorld = null;
    }

    @ModifyExpressionValue(method={"setStructureStart"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/gen/structure/StructureStart;writeStructureComponentsToNBT(II)Lnet/minecraft/nbt/NBTTagCompound;")})
    private NBTTagCompound aaam_invokeStructureWatchers(NBTTagCompound tags, @Local(argsOnly=true) StructureStart start) {
        if (!this.aaam$isInCorrectChunk || this.aaam$savedWorld == null) {
            return tags;
        }
        MapGenStructure structGen = (MapGenStructure)this;
        if (structGen instanceof MapGenVillage || ModCompat.otg.isLoaded() && OpenTerrainGeneratorCompat.isOTGVillage(structGen)) {
            ((StructureWatcherVillageAccessor)StructureWatcherReference.villageWatcher).invokeVisitVillage(this.aaam$savedWorld, tags);
        } else if (structGen instanceof MapGenNetherBridge) {
            ((StructureWatcherFortressAccessor)StructureWatcherReference.fortressWatcher).invokeVisitFortress(this.aaam$savedWorld, tags);
        } else if (structGen instanceof MapGenEndCity) {
            ((StructureWatcherGenericAccessor)StructureWatcherReference.endCityWatcher).invokeVisit(this.aaam$savedWorld, tags);
        }
        return tags;
    }
}

