/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.mixin.antiqueatlas.overhaul;

import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.PacketDispatcher;
import hunternif.mc.atlas.network.client.MarkersPacket;
import hunternif.mc.atlas.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MarkersData.class})
public abstract class MarkersPacketChunking {
    @Shadow(remap=false)
    @Final
    private Map<Integer, DimensionMarkersData> dimensionMap;
    @Shadow(remap=false)
    @Final
    private Set<EntityPlayer> playersSentTo;
    @Unique
    private static final int MARKERS_PER_PACKET = 100;

    @Shadow(remap=false)
    public abstract DimensionMarkersData getMarkersDataInDimension(int var1);

    @Shadow(remap=false)
    abstract MarkersPacket newMarkersPacket(int var1, int var2);

    @Overwrite(remap=false)
    public void syncOnPlayer(int atlasID, EntityPlayer player) {
        int totalMarkersSent = 0;
        for (Integer dimension : this.dimensionMap.keySet()) {
            Collection allMarkersInDimension = this.getMarkersDataInDimension(dimension).getAllMarkers();
            totalMarkersSent += allMarkersInDimension.size();
            ArrayList<Marker> markersChunk = new ArrayList<Marker>(100);
            for (Marker marker : allMarkersInDimension) {
                markersChunk.add(marker);
                if (markersChunk.size() < 100) continue;
                MarkersPacket p = this.newMarkersPacket(atlasID, dimension);
                for (Marker markerInChunk : markersChunk) {
                    p.putMarker(markerInChunk);
                }
                PacketDispatcher.sendTo((IMessage)p, (EntityPlayerMP)((EntityPlayerMP)player));
                markersChunk.clear();
            }
            if (markersChunk.isEmpty()) continue;
            MarkersPacket p = this.newMarkersPacket(atlasID, dimension);
            for (Marker markerInChunk : markersChunk) {
                p.putMarker(markerInChunk);
            }
            PacketDispatcher.sendTo((IMessage)p, (EntityPlayerMP)((EntityPlayerMP)player));
        }
        Log.info((String)"Sent markers data #%d to player %s (%d markers)", (Object[])new Object[]{atlasID, player.func_70005_c_(), totalMarkersSent});
        this.playersSentTo.add(player);
    }
}

