/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.mixin.antiqueatlas.mapselection;

import antiqueatlasautomarker.util.MapWaystoneSelectionUtil;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import hunternif.mc.atlas.client.gui.GuiAtlas;
import hunternif.mc.atlas.client.gui.GuiBookmarkButton;
import hunternif.mc.atlas.marker.DimensionMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageTeleportToWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiAtlas.class})
public abstract class GuiAtlasMixin {
    @Shadow(remap=false)
    private Marker hoveredMarker;
    @Shadow(remap=false)
    private EntityPlayer player;
    @Shadow(remap=false)
    @Final
    private GuiBookmarkButton btnExportPng;
    @Shadow(remap=false)
    @Final
    private GuiBookmarkButton btnDelMarker;
    @Shadow(remap=false)
    @Final
    private GuiBookmarkButton btnShowMarkers;
    @Shadow(remap=false)
    @Final
    private GuiBookmarkButton btnMarker;
    @Unique
    private DimensionMarkersData aaam$waystoneMarkers = null;
    @Unique
    private Map<Marker, WaystoneEntry> aaam$markerToWaystoneMap = null;
    @Unique
    private MapWaystoneSelectionUtil.WarpProperty aaam$warpProperty = null;

    @WrapOperation(method={"updateAtlasData"}, at={@At(value="INVOKE", target="Lhunternif/mc/atlas/marker/MarkersData;getMarkersDataInDimension(I)Lhunternif/mc/atlas/marker/DimensionMarkersData;")}, remap=false)
    private DimensionMarkersData aaam_rerouteIfWaystone(MarkersData instance, int dimension, Operation<DimensionMarkersData> original) {
        MapWaystoneSelectionUtil.WarpProperty warpProperty = MapWaystoneSelectionUtil.getAndClearThreadLocal();
        if (warpProperty == null && this.aaam$waystoneMarkers == null) {
            return (DimensionMarkersData)original.call(new Object[]{instance, dimension});
        }
        if (this.aaam$waystoneMarkers == null) {
            this.aaam$waystoneMarkers = new DimensionMarkersData(instance, dimension);
            this.aaam$warpProperty = warpProperty;
            this.aaam$markerToWaystoneMap = new HashMap<Marker, WaystoneEntry>();
            this.btnExportPng.setEnabled(false);
            this.btnDelMarker.setEnabled(false);
            this.btnShowMarkers.setEnabled(false);
            this.btnMarker.setEnabled(false);
            MapWaystoneSelectionUtil.setFromWaystone(true);
            int id = 0;
            boolean costsXp = GuiAtlasMixin.aaam$getCostsXp(warpProperty.mode);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            int playerXpLvl = player.field_71068_ca;
            for (WaystoneEntry entry : warpProperty.entries) {
                if (entry.getDimensionId() != dimension) continue;
                int xpCost = PlayerWaystoneHelper.getTravelCostByDistance((EntityPlayer)player, (WaystoneEntry)entry);
                Marker marker = new Marker(id++, "antiqueatlas:waystone", GuiAtlasMixin.aaam$getWaystoneMarkerName(entry, costsXp, xpCost, playerXpLvl), dimension, entry.getPos().func_177958_n(), entry.getPos().func_177952_p(), true);
                this.aaam$waystoneMarkers.insertMarker(marker);
                if (xpCost > playerXpLvl && costsXp) continue;
                this.aaam$markerToWaystoneMap.put(marker, entry);
            }
        }
        return this.aaam$waystoneMarkers;
    }

    @Unique
    private static String aaam$getWaystoneMarkerName(WaystoneEntry entry, boolean costsXP, int xpCost, int playerXpLvl) {
        String s = entry.getName();
        if (xpCost > 0 && costsXP) {
            s = s + " (";
            s = xpCost > playerXpLvl ? s + TextFormatting.RED : s + TextFormatting.GREEN;
            s = s + "" + xpCost + TextFormatting.RESET + ")";
        }
        return s;
    }

    @Unique
    private static boolean aaam$getCostsXp(WarpMode mode) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        switch (mode) {
            case INVENTORY_BUTTON: {
                if (WaystoneConfig.general.teleportButton && !WaystoneConfig.general.teleportButtonReturnOnly && WaystoneConfig.general.teleportButtonTarget.isEmpty()) {
                    return WaystoneConfig.general.inventoryButtonXpCost && !player.field_71075_bZ.field_75098_d;
                }
                return false;
            }
            case WARP_SCROLL: {
                return false;
            }
            case WARP_STONE: {
                return WaystoneConfig.general.warpStoneXpCost && !player.field_71075_bZ.field_75098_d;
            }
            case WAYSTONE: {
                return WaystoneConfig.general.waystoneXpCost && !player.field_71075_bZ.field_75098_d;
            }
        }
        return true;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lhunternif/mc/atlas/client/gui/core/GuiStates;is(Lhunternif/mc/atlas/client/gui/core/GuiStates$IState;)Z", ordinal=0, remap=false)}, cancellable=true)
    private void aaam_teleportToMarker(int mouseX, int mouseY, int mouseState, CallbackInfo ci) {
        WaystoneEntry entry;
        if (MapWaystoneSelectionUtil.getIsFromWaystone() && (entry = this.aaam$markerToWaystoneMap.get(this.hoveredMarker)) != null) {
            NetworkHandler.channel.sendToServer((IMessage)new MessageTeleportToWaystone(entry, this.aaam$warpProperty.mode, this.aaam$warpProperty.hand, this.aaam$warpProperty.fromWaystone));
            this.player.func_71053_j();
            ci.cancel();
        }
    }

    @Inject(method={"onGuiClosed"}, at={@At(value="TAIL")})
    private void aaam_resetGUI(CallbackInfo ci) {
        this.aaam$waystoneMarkers = null;
        this.aaam$markerToWaystoneMap = null;
        this.aaam$warpProperty = null;
        this.btnExportPng.setEnabled(true);
        this.btnDelMarker.setEnabled(true);
        this.btnShowMarkers.setEnabled(true);
        this.btnMarker.setEnabled(true);
        MapWaystoneSelectionUtil.setFromWaystone(false);
    }
}

