/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.mixin.antiqueatlas.biometiles;

import antiqueatlasautomarker.custombiometiles.NetherTiles;
import antiqueatlasautomarker.event.BiomeDetectorEvent;
import hunternif.mc.atlas.core.BiomeDetectorBase;
import hunternif.mc.atlas.core.BiomeDetectorNether;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.util.ByteUtil;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BiomeDetectorNether.class})
public abstract class CustomNetherBiomesWithLava
extends BiomeDetectorBase {
    @Shadow(remap=false)
    @Final
    private static int airProbeLevel;
    @Shadow(remap=false)
    @Final
    private static int lavaSeaLevel;
    @Unique
    private static final int aaam$priorityBiome = 3;
    @Unique
    private static final int aaam$priorityLava = 4;
    @Unique
    private static final int aaam$priorityWall = 4;

    @Overwrite(remap=false)
    public int getBiomeID(Chunk chunk) {
        int[] chunkBiomes;
        int biomesCount = Biome.field_185377_q.func_148742_b().size();
        try {
            chunkBiomes = ByteUtil.unsignedByteToIntArray((Object)biomeArrayMethod.invoke((Object)chunk, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        int[] biomeOccurrences = new int[biomesCount];
        int lavaOccurrences = 0;
        int wallOccurrences = 0;
        int hellID = Biome.func_185362_a((Biome)Biomes.field_76778_j);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int biomeID = chunkBiomes[x << 4 | z];
                if (chunk.func_186032_a(x, lavaSeaLevel, z).func_177230_c() == Blocks.field_150353_l) {
                    lavaOccurrences += 4;
                }
                if (chunk.func_186032_a(x, airProbeLevel, z).func_177230_c() != Blocks.field_150350_a) {
                    wallOccurrences += 4;
                }
                if (biomeID != hellID && (biomeID < 0 || biomeID >= biomesCount || Biome.func_185357_a((int)biomeID) == null)) continue;
                int n = biomeID;
                biomeOccurrences[n] = biomeOccurrences[n] + 3;
            }
        }
        int meanBiomeId = -1;
        int meanBiomeOccurences = 0;
        for (int i = 0; i < biomeOccurrences.length; ++i) {
            if (biomeOccurrences[i] <= meanBiomeOccurences) continue;
            meanBiomeId = i;
            meanBiomeOccurences = biomeOccurrences[i];
        }
        int retValue = meanBiomeId;
        int lavaId = ExtTileIdMap.instance().getPseudoBiomeID("lava");
        if (wallOccurrences > lavaOccurrences && wallOccurrences >= meanBiomeOccurences) {
            retValue = NetherTiles.WALL;
        } else if (lavaOccurrences >= meanBiomeOccurences) {
            retValue = lavaId;
        }
        BiomeDetectorEvent event = new BiomeDetectorEvent(chunk, retValue);
        event.setCountAndIdFor("lava", lavaId, lavaOccurrences);
        event.setCountAndIdFor("wall", NetherTiles.WALL, wallOccurrences);
        event.setCountAndIdFor("biome", meanBiomeId, meanBiomeOccurences);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getChosenBiomeId();
    }
}

