/*
 * Decompiled with CFR 0.152.
 */
package antiqueatlasautomarker.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;

public class BiomeDetectorEvent
extends ChunkEvent {
    private final Map<String, Integer> counts = new HashMap<String, Integer>();
    private final Map<String, Integer> ids = new HashMap<String, Integer>();
    private Biome mainBiome = null;
    private final int dimension;
    private int chosenBiomeId;
    private String chosenType;

    public BiomeDetectorEvent(Chunk chunk, int chosenBiomeId) {
        super(chunk);
        this.chosenBiomeId = chosenBiomeId;
        this.dimension = chunk.func_177412_p().field_73011_w.getDimension();
    }

    public void setCountAndIdFor(String type, int tileId, int count) {
        this.ids.put(type, tileId);
        this.counts.put(type, count);
        if (type.equals("biome") && tileId >= 0) {
            this.mainBiome = Biome.func_185357_a((int)tileId);
        }
        if (tileId == this.chosenBiomeId) {
            this.chosenType = type;
        }
    }

    public void setChosenBiomeId(int id) {
        if (id != -1) {
            this.chosenBiomeId = id;
            if (id >= 0) {
                this.chosenType = "biome";
            } else {
                if (this.ids.containsValue(id)) {
                    for (Map.Entry<String, Integer> entry : this.counts.entrySet()) {
                        if (entry.getValue() != id) continue;
                        this.chosenType = entry.getKey();
                        return;
                    }
                }
                this.chosenType = "custom";
            }
        }
    }

    public int getChosenBiomeId() {
        return this.chosenBiomeId;
    }

    public boolean setChosenType(String type) {
        if (this.counts.containsKey(type)) {
            this.chosenType = type;
            this.chosenBiomeId = this.ids.get(type);
            return true;
        }
        return false;
    }

    public String getChosenType() {
        return this.chosenType;
    }

    public Biome getMainBiome() {
        return this.mainBiome;
    }

    public int getCountFor(String type) {
        return this.counts.getOrDefault(type, 0);
    }

    public int getIdFor(String type) {
        return this.ids.getOrDefault(type, -1);
    }

    public Set<String> getCountTypes() {
        return this.counts.keySet();
    }

    public int getDimension() {
        return this.dimension;
    }
}

